/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.apache.flink.runtime.util.BlockingCheckpointOutputStream;

@VisibleForTesting
@Internal
public class BlockerCheckpointStreamFactory
implements CheckpointStreamFactory {
    protected final int maxSize;
    protected volatile int afterNumberInvocations;
    protected volatile OneShotLatch blocker;
    protected volatile OneShotLatch waiter;
    protected final Set<BlockingCheckpointOutputStream> allCreatedStreams;

    public Set<BlockingCheckpointOutputStream> getAllCreatedStreams() {
        return this.allCreatedStreams;
    }

    public BlockerCheckpointStreamFactory(int maxSize) {
        this.maxSize = maxSize;
        this.allCreatedStreams = new HashSet<BlockingCheckpointOutputStream>();
    }

    public void setAfterNumberInvocations(int afterNumberInvocations) {
        this.afterNumberInvocations = afterNumberInvocations;
    }

    public void setBlockerLatch(OneShotLatch latch) {
        this.blocker = latch;
    }

    public void setWaiterLatch(OneShotLatch latch) {
        this.waiter = latch;
    }

    public OneShotLatch getBlockerLatch() {
        return this.blocker;
    }

    public OneShotLatch getWaiterLatch() {
        return this.waiter;
    }

    public CheckpointStateOutputStream createCheckpointStateOutputStream(CheckpointedStateScope scope) throws IOException {
        BlockingCheckpointOutputStream blockingStream = new BlockingCheckpointOutputStream((FSDataOutputStream)new MemCheckpointStreamFactory.MemoryCheckpointOutputStream(this.maxSize), this.waiter, this.blocker, this.afterNumberInvocations);
        this.allCreatedStreams.add(blockingStream);
        return blockingStream;
    }

    public boolean canFastDuplicate(StreamStateHandle stateHandle, CheckpointedStateScope scope) {
        return false;
    }

    public List<StreamStateHandle> duplicate(List<StreamStateHandle> stateHandles, CheckpointedStateScope scope) throws IOException {
        throw new UnsupportedOperationException();
    }
}

