/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.util.HashMap;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.v2.InternalKeyedStateTestBase;
import org.apache.flink.runtime.state.v2.InternalMapState;
import org.apache.flink.runtime.state.v2.MapStateDescriptor;
import org.junit.jupiter.api.Test;

public class InternalMapStateTest
extends InternalKeyedStateTestBase {
    @Test
    public void testEachOperation() {
        MapStateDescriptor descriptor = new MapStateDescriptor("testState", (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        InternalMapState mapState = new InternalMapState((StateRequestHandler)this.aec, descriptor);
        this.aec.setCurrentContext(this.aec.buildContext((Object)"test", (Object)"test"));
        mapState.asyncClear();
        this.validateRequestRun((State)mapState, StateRequestType.CLEAR, null);
        mapState.asyncGet((Object)"key1");
        this.validateRequestRun((State)mapState, StateRequestType.MAP_GET, "key1");
        mapState.asyncPut((Object)"key2", (Object)2);
        this.validateRequestRun((State)mapState, StateRequestType.MAP_PUT, Tuple2.of((Object)"key2", (Object)2));
        HashMap map = new HashMap();
        mapState.asyncPutAll(map);
        this.validateRequestRun((State)mapState, StateRequestType.MAP_PUT_ALL, map);
        mapState.asyncRemove((Object)"key3");
        this.validateRequestRun((State)mapState, StateRequestType.MAP_REMOVE, "key3");
        mapState.asyncContains((Object)"key4");
        this.validateRequestRun((State)mapState, StateRequestType.MAP_CONTAINS, "key4");
        mapState.asyncEntries();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_ITER, null);
        mapState.asyncKeys();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_ITER_KEY, null);
        mapState.asyncValues();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_ITER_VALUE, null);
        mapState.asyncIsEmpty();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_IS_EMPTY, null);
    }
}

