/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Iterator;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KeyGroupRangeTest {
    KeyGroupRangeTest() {
    }

    @Test
    void testKeyGroupIntersection() {
        KeyGroupRange keyGroupRange1 = KeyGroupRange.of((int)0, (int)10);
        KeyGroupRange keyGroupRange2 = KeyGroupRange.of((int)3, (int)7);
        KeyGroupRange intersection = keyGroupRange1.getIntersection(keyGroupRange2);
        Assertions.assertThat((int)intersection.getStartKeyGroup()).isEqualTo(3);
        Assertions.assertThat((int)intersection.getEndKeyGroup()).isEqualTo(7);
        Assertions.assertThat((Iterable)keyGroupRange2.getIntersection(keyGroupRange1)).isEqualTo((Object)intersection);
        Assertions.assertThat((Iterable)keyGroupRange1.getIntersection(keyGroupRange1)).isEqualTo((Object)keyGroupRange1);
        keyGroupRange1 = KeyGroupRange.of((int)0, (int)5);
        keyGroupRange2 = KeyGroupRange.of((int)6, (int)10);
        intersection = keyGroupRange1.getIntersection(keyGroupRange2);
        Assertions.assertThat((Iterable)intersection).isEqualTo((Object)KeyGroupRange.EMPTY_KEY_GROUP_RANGE);
        Assertions.assertThat((Iterable)intersection).isEqualTo((Object)keyGroupRange2.getIntersection(keyGroupRange1));
        keyGroupRange1 = KeyGroupRange.of((int)0, (int)10);
        keyGroupRange2 = KeyGroupRange.of((int)5, (int)20);
        intersection = keyGroupRange1.getIntersection(keyGroupRange2);
        Assertions.assertThat((int)intersection.getStartKeyGroup()).isEqualTo(5);
        Assertions.assertThat((int)intersection.getEndKeyGroup()).isEqualTo(10);
        Assertions.assertThat((Iterable)keyGroupRange2.getIntersection(keyGroupRange1)).isEqualTo((Object)intersection);
        keyGroupRange1 = KeyGroupRange.of((int)3, (int)12);
        keyGroupRange2 = KeyGroupRange.of((int)0, (int)10);
        intersection = keyGroupRange1.getIntersection(keyGroupRange2);
        Assertions.assertThat((int)intersection.getStartKeyGroup()).isEqualTo(3);
        Assertions.assertThat((int)intersection.getEndKeyGroup()).isEqualTo(10);
        Assertions.assertThat((Iterable)keyGroupRange2.getIntersection(keyGroupRange1)).isEqualTo((Object)intersection);
    }

    @Test
    void testKeyGroupRangeBasics() {
        this.testKeyGroupRangeBasicsInternal(0, 0);
        this.testKeyGroupRangeBasicsInternal(0, 1);
        this.testKeyGroupRangeBasicsInternal(1, 2);
        this.testKeyGroupRangeBasicsInternal(42, 42);
        this.testKeyGroupRangeBasicsInternal(3, 7);
        this.testKeyGroupRangeBasicsInternal(0, Short.MAX_VALUE);
        this.testKeyGroupRangeBasicsInternal(32766, Short.MAX_VALUE);
        Assertions.assertThatThrownBy(() -> this.testKeyGroupRangeBasicsInternal(-3, 2)).isInstanceOf(IllegalArgumentException.class);
    }

    private void testKeyGroupRangeBasicsInternal(int startKeyGroup, int endKeyGroup) {
        KeyGroupRange keyGroupRange = KeyGroupRange.of((int)startKeyGroup, (int)endKeyGroup);
        int numberOfKeyGroup = keyGroupRange.getNumberOfKeyGroups();
        Assertions.assertThat((int)numberOfKeyGroup).isEqualTo(Math.max(0, endKeyGroup - startKeyGroup + 1));
        if (keyGroupRange.getNumberOfKeyGroups() > 0) {
            Assertions.assertThat((int)keyGroupRange.getStartKeyGroup()).isEqualTo(startKeyGroup);
            Assertions.assertThat((int)keyGroupRange.getEndKeyGroup()).isEqualTo(endKeyGroup);
            int c = startKeyGroup;
            Iterator iterator = keyGroupRange.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                Assertions.assertThat((int)i).isEqualTo(c);
                Assertions.assertThat((boolean)keyGroupRange.contains(i)).isTrue();
                ++c;
            }
            Assertions.assertThat((int)c).isEqualTo(endKeyGroup + 1);
            Assertions.assertThat((boolean)keyGroupRange.contains(startKeyGroup - 1)).isFalse();
            Assertions.assertThat((boolean)keyGroupRange.contains(endKeyGroup + 1)).isFalse();
        } else {
            Assertions.assertThat((Iterable)keyGroupRange).isEqualTo((Object)KeyGroupRange.EMPTY_KEY_GROUP_RANGE);
        }
    }
}

