/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.runtime.state.JavaSerializer;
import org.assertj.core.api.Condition;

class JavaSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Serializable, Serializable> {
    private static final String SPEC_NAME = "java-serializer";

    JavaSerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, flinkVersion, JavaSerializerSetup.class, JavaSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class JavaSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Serializable> {
        public TypeSerializer<Serializable> createUpgradedSerializer() {
            return new JavaSerializer();
        }

        public Condition<Serializable> testDataCondition() {
            return new Condition(value -> 26 == (Integer)value, "", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<Serializable>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class JavaSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Serializable> {
        public TypeSerializer<Serializable> createPriorSerializer() {
            return new JavaSerializer();
        }

        public Serializable createTestData() {
            return Integer.valueOf(26);
        }
    }
}

