/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.io.InputStreamFSInputWrapper;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.runtime.state.CompressibleFSDataInputStream;
import org.apache.flink.runtime.state.CompressibleFSDataOutputStream;
import org.apache.flink.runtime.state.SnappyStreamCompressionDecorator;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CompressibleFSDataInputStreamTest {
    CompressibleFSDataInputStreamTest() {
    }

    private static void verifyRecord(FSDataInputStream inputStream, Map<String, Long> positions, String record) throws IOException {
        inputStream.seek(Objects.requireNonNull(positions.get(record)).longValue());
        byte[] readBuffer = new byte[record.getBytes(StandardCharsets.UTF_8).length];
        for (int i = 0; i < readBuffer.length; ++i) {
            readBuffer[i] = (byte)inputStream.read();
        }
        Assertions.assertThat((byte[])readBuffer).asString(StandardCharsets.UTF_8).isEqualTo(record);
    }

    private static void verifyRecordPrefix(FSDataInputStream inputStream, Map<String, Long> positions, String record, String prefix) throws IOException {
        Assertions.assertThat((String)record).startsWith((CharSequence)prefix);
        inputStream.seek(Objects.requireNonNull(positions.get(record)).longValue());
        byte[] readBuffer = new byte[prefix.getBytes(StandardCharsets.UTF_8).length];
        for (int i = 0; i < readBuffer.length; ++i) {
            readBuffer[i] = (byte)inputStream.read();
        }
        Assertions.assertThat((byte[])readBuffer).asString(StandardCharsets.UTF_8).isEqualTo(prefix);
    }

    @Test
    void testSeek() throws IOException {
        CompressibleFSDataInputStream compressibleInputStream2;
        byte[] compressedBytes;
        Throwable throwable;
        List<String> records = Arrays.asList("first", "second", "third", "fourth", "fifth");
        HashMap<String, Long> positions = new HashMap<String, Long>();
        try (TestingOutputStream outputStream = new TestingOutputStream();){
            throwable = null;
            try (CompressibleFSDataOutputStream compressibleOutputStream = new CompressibleFSDataOutputStream((FSDataOutputStream)outputStream, (StreamCompressionDecorator)new SnappyStreamCompressionDecorator());){
                for (String record : records) {
                    positions.put(record, compressibleOutputStream.getPos());
                    compressibleOutputStream.write(record.getBytes(StandardCharsets.UTF_8));
                }
                compressibleOutputStream.flush();
                compressedBytes = outputStream.toByteArray();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var5_4 = null;
        try (InputStreamFSInputWrapper inputStream = new InputStreamFSInputWrapper((InputStream)new ByteArrayInputStream(compressedBytes));){
            compressibleInputStream2 = new CompressibleFSDataInputStream((FSDataInputStream)inputStream, (StreamCompressionDecorator)new SnappyStreamCompressionDecorator());
            throwable = null;
            try {
                CompressibleFSDataInputStreamTest.verifyRecord((FSDataInputStream)compressibleInputStream2, positions, "first");
                CompressibleFSDataInputStreamTest.verifyRecord((FSDataInputStream)compressibleInputStream2, positions, "third");
                CompressibleFSDataInputStreamTest.verifyRecord((FSDataInputStream)compressibleInputStream2, positions, "fifth");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (compressibleInputStream2 != null) {
                    if (throwable != null) {
                        try {
                            compressibleInputStream2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        compressibleInputStream2.close();
                    }
                }
            }
        }
        catch (Throwable compressibleInputStream2) {
            var5_4 = compressibleInputStream2;
            throw compressibleInputStream2;
        }
        inputStream = new InputStreamFSInputWrapper((InputStream)new ByteArrayInputStream(compressedBytes));
        var5_4 = null;
        try {
            compressibleInputStream2 = new CompressibleFSDataInputStream((FSDataInputStream)inputStream, (StreamCompressionDecorator)new SnappyStreamCompressionDecorator());
            throwable = null;
            try {
                CompressibleFSDataInputStreamTest.verifyRecordPrefix((FSDataInputStream)compressibleInputStream2, positions, "first", "fir");
                CompressibleFSDataInputStreamTest.verifyRecordPrefix((FSDataInputStream)compressibleInputStream2, positions, "third", "thi");
                CompressibleFSDataInputStreamTest.verifyRecord((FSDataInputStream)compressibleInputStream2, positions, "fifth");
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (compressibleInputStream2 != null) {
                    if (throwable != null) {
                        try {
                            compressibleInputStream2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        compressibleInputStream2.close();
                    }
                }
            }
        }
        catch (Throwable throwable7) {
            var5_4 = throwable7;
            throw throwable7;
        }
        finally {
            if (inputStream != null) {
                if (var5_4 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable8) {
                        var5_4.addSuppressed(throwable8);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
    }

    private static class TestingOutputStream
    extends FSDataOutputStream {
        private final ByteArrayOutputStreamWithPos delegate = new ByteArrayOutputStreamWithPos();

        private TestingOutputStream() {
        }

        public long getPos() {
            return this.delegate.getPosition();
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void sync() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.delegate.close();
        }

        public void write(int b) {
            this.delegate.write(b);
        }

        byte[] toByteArray() {
            return this.delegate.toByteArray();
        }
    }
}

