/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.modules;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.modules.JaasModule;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JaasModuleTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void setUp() throws IOException {
        System.getProperties().remove("java.security.auth.login.config");
        this.folder.create();
    }

    @Test
    public void testJaasModuleFilePathIfWorkingDirPresent() throws IOException {
        File file = this.folder.newFolder();
        this.testJaasModuleFilePath(file.toPath().toString());
    }

    @Test
    public void testJaasModuleFilePathIfWorkingDirNotPresent() throws IOException {
        File file = this.folder.newFolder();
        this.testJaasModuleFilePath(file.toPath().toString() + "/tmp");
    }

    @Test
    public void testJaasModuleFilePathIfWorkingDirIsSymLink() throws IOException {
        Path symlink = this.createSymLinkFolderStructure();
        this.testJaasModuleFilePath(symlink.toString());
    }

    @Test
    public void testJaasModuleFilePathIfWorkingDirNoPresentAndPathContainsSymLink() throws IOException {
        Path symlink = this.createSymLinkFolderStructure();
        this.testJaasModuleFilePath(symlink.toString() + "/tmp");
    }

    private Path createSymLinkFolderStructure() throws IOException {
        File baseFolder = this.folder.newFolder();
        File actualFolder = new File(baseFolder, "actual_folder");
        Assert.assertTrue((boolean)actualFolder.mkdirs());
        Path symlink = new File(baseFolder, "symlink").toPath();
        Files.createSymbolicLink(symlink, actualFolder.toPath(), new FileAttribute[0]);
        return symlink;
    }

    private void testJaasModuleFilePath(String workingDir) throws IOException {
        Configuration configuration = new Configuration();
        configuration.set(CoreOptions.TMP_DIRS, (Object)workingDir);
        SecurityConfiguration sc = new SecurityConfiguration(configuration);
        JaasModule module = new JaasModule(sc);
        module.install();
        this.assertJaasFileLocateInRightDirectory(workingDir);
    }

    @Test
    public void testCreateJaasModuleFileInTemporary() throws IOException {
        Configuration configuration = new Configuration();
        SecurityConfiguration sc = new SecurityConfiguration(configuration);
        JaasModule module = new JaasModule(sc);
        module.install();
        this.assertJaasFileLocateInRightDirectory((String)CoreOptions.TMP_DIRS.defaultValue());
    }

    private void assertJaasFileLocateInRightDirectory(String directory) throws IOException {
        String resolvedExpectedPath = new File(directory).toPath().toRealPath(new LinkOption[0]).toString();
        String resolvedActualPathWithFile = new File(System.getProperty("java.security.auth.login.config")).toPath().toRealPath(new LinkOption[0]).toString();
        Assert.assertThat((String)"The resolved configured directory does not match the expected resolved one.", (Object)resolvedActualPathWithFile, (Matcher)StringStartsWith.startsWith((String)resolvedExpectedPath));
        Assert.assertThat((String)"The configured directory does not match the expected one.", (Object)System.getProperty("java.security.auth.login.config"), (Matcher)StringStartsWith.startsWith((String)directory));
    }
}

