/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.assertj.core.api.Assertions;

class StrategyTestUtil {
    StrategyTestUtil() {
    }

    static void assertLatestScheduledVerticesAreEqualTo(List<List<TestingSchedulingExecutionVertex>> expected, TestingSchedulerOperations testingSchedulerOperation) {
        List<List<ExecutionVertexID>> allScheduledVertices = testingSchedulerOperation.getScheduledVertices();
        int expectedScheduledBulks = expected.size();
        Assertions.assertThat((int)expectedScheduledBulks).isLessThanOrEqualTo(allScheduledVertices.size());
        for (int i = 0; i < expectedScheduledBulks; ++i) {
            Assertions.assertThat(allScheduledVertices.get(allScheduledVertices.size() - i - 1)).isEqualTo(StrategyTestUtil.idsFromVertices(expected.get(expectedScheduledBulks - i - 1)));
        }
    }

    static List<ExecutionVertexID> idsFromVertices(List<TestingSchedulingExecutionVertex> vertices) {
        return vertices.stream().map(TestingSchedulingExecutionVertex::getId).collect(Collectors.toList());
    }
}

