/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.scalingpolicy;

import java.util.Collections;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.runtime.scheduler.adaptive.scalingpolicy.EnforceParallelismChangeRescalingController;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EnforceParallelismChangeRescalingControllerTest {
    private static final JobVertexID jobVertexId = new JobVertexID();

    EnforceParallelismChangeRescalingControllerTest() {
    }

    @Test
    void testScaleUp() {
        EnforceParallelismChangeRescalingController rescalingController = new EnforceParallelismChangeRescalingController();
        Assertions.assertThat((boolean)rescalingController.shouldRescale(EnforceParallelismChangeRescalingControllerTest.forParallelism(1), EnforceParallelismChangeRescalingControllerTest.forParallelism(2))).isTrue();
    }

    @Test
    void testAlwaysScaleDown() {
        EnforceParallelismChangeRescalingController rescalingController = new EnforceParallelismChangeRescalingController();
        Assertions.assertThat((boolean)rescalingController.shouldRescale(EnforceParallelismChangeRescalingControllerTest.forParallelism(2), EnforceParallelismChangeRescalingControllerTest.forParallelism(1))).isTrue();
    }

    @Test
    void testNoScaleOnSameParallelism() {
        EnforceParallelismChangeRescalingController rescalingController = new EnforceParallelismChangeRescalingController();
        Assertions.assertThat((boolean)rescalingController.shouldRescale(EnforceParallelismChangeRescalingControllerTest.forParallelism(2), EnforceParallelismChangeRescalingControllerTest.forParallelism(2))).isFalse();
    }

    private static VertexParallelism forParallelism(int parallelism) {
        return new VertexParallelism(Collections.singletonMap(jobVertexId, parallelism));
    }
}

