/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProvider;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequest;
import org.apache.flink.runtime.scheduler.TestingPhysicalSlot;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class TestingPhysicalSlotProvider
implements PhysicalSlotProvider {
    private final Map<SlotRequestId, PhysicalSlotRequest> requests;
    private final Map<SlotRequestId, CompletableFuture<TestingPhysicalSlot>> responses;
    private final Map<SlotRequestId, Throwable> cancellations;
    private final Function<ResourceProfile, CompletableFuture<TestingPhysicalSlot>> physicalSlotCreator;
    private boolean batchSlotRequestTimeoutCheckEnabled = true;

    public static TestingPhysicalSlotProvider create(Function<ResourceProfile, CompletableFuture<TestingPhysicalSlot>> physicalSlotCreator) {
        return new TestingPhysicalSlotProvider(physicalSlotCreator);
    }

    public static TestingPhysicalSlotProvider createWithInfiniteSlotCreation() {
        return TestingPhysicalSlotProvider.create(resourceProfile -> CompletableFuture.completedFuture(new TestingPhysicalSlot((ResourceProfile)resourceProfile, new AllocationID())));
    }

    public static TestingPhysicalSlotProvider createWithoutImmediatePhysicalSlotCreation() {
        return TestingPhysicalSlotProvider.create(ignored -> new CompletableFuture());
    }

    public static TestingPhysicalSlotProvider createWithFailingPhysicalSlotCreation(Throwable t) {
        return TestingPhysicalSlotProvider.create(ignored -> FutureUtils.completedExceptionally((Throwable)t));
    }

    public static TestingPhysicalSlotProvider createWithLimitedAmountOfPhysicalSlots(int slotCount) {
        return TestingPhysicalSlotProvider.createWithLimitedAmountOfPhysicalSlots(slotCount, new SimpleAckingTaskManagerGateway());
    }

    public static TestingPhysicalSlotProvider createWithLimitedAmountOfPhysicalSlots(int slotCount, TaskManagerGateway taskManagerGateway) {
        AtomicInteger availableSlotCount = new AtomicInteger(slotCount);
        return TestingPhysicalSlotProvider.create(resourceProfile -> {
            int count = availableSlotCount.getAndDecrement();
            if (count > 0) {
                return CompletableFuture.completedFuture(TestingPhysicalSlot.builder().withResourceProfile((ResourceProfile)resourceProfile).withTaskManagerGateway(taskManagerGateway).build());
            }
            return FutureUtils.completedExceptionally((Throwable)new NoResourceAvailableException(String.format("The limit of %d provided slots was reached. No available slots can be provided.", slotCount)));
        });
    }

    private TestingPhysicalSlotProvider(Function<ResourceProfile, CompletableFuture<TestingPhysicalSlot>> physicalSlotCreator) {
        this.physicalSlotCreator = physicalSlotCreator;
        this.requests = new HashMap<SlotRequestId, PhysicalSlotRequest>();
        this.responses = new HashMap<SlotRequestId, CompletableFuture<TestingPhysicalSlot>>();
        this.cancellations = new HashMap<SlotRequestId, Throwable>();
    }

    public Map<SlotRequestId, CompletableFuture<PhysicalSlotRequest.Result>> allocatePhysicalSlots(Collection<PhysicalSlotRequest> physicalSlotRequests) {
        HashMap<SlotRequestId, CompletableFuture<PhysicalSlotRequest.Result>> result = new HashMap<SlotRequestId, CompletableFuture<PhysicalSlotRequest.Result>>(physicalSlotRequests.size());
        for (PhysicalSlotRequest physicalSlotRequest : physicalSlotRequests) {
            SlotRequestId slotRequestId = physicalSlotRequest.getSlotRequestId();
            this.requests.put(slotRequestId, physicalSlotRequest);
            CompletableFuture<TestingPhysicalSlot> resultFuture = this.physicalSlotCreator.apply(physicalSlotRequest.getSlotProfile().getPhysicalSlotResourceProfile());
            this.responses.put(slotRequestId, resultFuture);
            CompletionStage physicalSlotFuture = resultFuture.thenApply(physicalSlot -> new PhysicalSlotRequest.Result(slotRequestId, (PhysicalSlot)physicalSlot));
            result.put(slotRequestId, (CompletableFuture<PhysicalSlotRequest.Result>)physicalSlotFuture);
        }
        return result;
    }

    public void cancelSlotRequest(SlotRequestId slotRequestId, Throwable cause) {
        this.cancellations.put(slotRequestId, cause);
    }

    public void disableBatchSlotRequestTimeoutCheck() {
        this.batchSlotRequestTimeoutCheckEnabled = false;
    }

    public CompletableFuture<TestingPhysicalSlot> getResultForRequestId(SlotRequestId slotRequestId) {
        return this.getResponses().get(slotRequestId);
    }

    PhysicalSlotRequest getFirstRequestOrFail() {
        return TestingPhysicalSlotProvider.getFirstElementOrFail(this.requests.values());
    }

    public void awaitAllSlotRequests() {
        this.getResponses().values().forEach(CompletableFuture::join);
    }

    public Map<SlotRequestId, PhysicalSlotRequest> getRequests() {
        return Collections.unmodifiableMap(this.requests);
    }

    public CompletableFuture<TestingPhysicalSlot> getFirstResponseOrFail() {
        return TestingPhysicalSlotProvider.getFirstElementOrFail(this.responses.values());
    }

    public Map<SlotRequestId, CompletableFuture<TestingPhysicalSlot>> getResponses() {
        return Collections.unmodifiableMap(this.responses);
    }

    public Map<SlotRequestId, Throwable> getCancellations() {
        return Collections.unmodifiableMap(this.cancellations);
    }

    private static <T> T getFirstElementOrFail(Collection<T> collection) {
        Optional<T> element = collection.stream().findFirst();
        Preconditions.checkState((boolean)element.isPresent());
        return element.get();
    }

    boolean isBatchSlotRequestTimeoutCheckEnabled() {
        return this.batchSlotRequestTimeoutCheckEnabled;
    }
}

