/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.DefaultSyncPreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.TestingInputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultSyncPreferredLocationsRetrieverTest {
    private static final JobVertexID JV1 = new JobVertexID();
    private static final ExecutionVertexID EV11 = new ExecutionVertexID(JV1, 0);
    private static final ExecutionVertexID EV12 = new ExecutionVertexID(JV1, 1);
    private static final ExecutionVertexID EV13 = new ExecutionVertexID(JV1, 2);
    private static final ExecutionVertexID EV14 = new ExecutionVertexID(JV1, 3);
    private static final ExecutionVertexID EV21 = new ExecutionVertexID(new JobVertexID(), 0);

    DefaultSyncPreferredLocationsRetrieverTest() {
    }

    @Test
    void testAvailableInputLocationRetrieval() {
        TestingInputsLocationsRetriever originalLocationRetriever = new TestingInputsLocationsRetriever.Builder().connectConsumerToProducers(EV21, Arrays.asList(EV11, EV12, EV13, EV14)).build();
        originalLocationRetriever.assignTaskManagerLocation(EV11);
        originalLocationRetriever.markScheduled(EV12);
        originalLocationRetriever.failTaskManagerLocation(EV13, new Throwable());
        originalLocationRetriever.cancelTaskManagerLocation(EV14);
        DefaultSyncPreferredLocationsRetriever locationsRetriever = new DefaultSyncPreferredLocationsRetriever(executionVertexId -> Optional.empty(), (InputsLocationsRetriever)originalLocationRetriever);
        Collection preferredLocations = locationsRetriever.getPreferredLocations(EV21, Collections.emptySet());
        TaskManagerLocation expectedLocation = originalLocationRetriever.getTaskManagerLocation(EV11).get().join();
        Assertions.assertThat((Collection)preferredLocations).containsExactly((Object[])new TaskManagerLocation[]{expectedLocation});
    }
}

