/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.flink.runtime.rest.handler.FileUploads;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileUploadsTest {
    @TempDir
    private Path temporaryFolder;

    FileUploadsTest() {
    }

    @Test
    void testRelativePathRejection() {
        Path relative = Paths.get("root", new String[0]);
        Assertions.assertThatThrownBy(() -> new FileUploads(relative)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDirectoryScan() throws IOException {
        Path rootDir = Paths.get("root", new String[0]);
        Path rootFile = rootDir.resolve("rootFile");
        Path subDir = rootDir.resolve("sub");
        Path subFile = subDir.resolve("subFile");
        Path tmp = this.temporaryFolder;
        Files.createDirectory(tmp.resolve(rootDir), new FileAttribute[0]);
        Files.createDirectory(tmp.resolve(subDir), new FileAttribute[0]);
        Files.createFile(tmp.resolve(rootFile), new FileAttribute[0]);
        Files.createFile(tmp.resolve(subFile), new FileAttribute[0]);
        try (FileUploads fileUploads = new FileUploads(tmp.resolve(rootDir));){
            Collection detectedFiles = fileUploads.getUploadedFiles().stream().map(File::toPath).collect(Collectors.toList());
            Assertions.assertThat((Collection)detectedFiles).hasSize(2);
            Assertions.assertThat((Collection)detectedFiles).contains((Object[])new Path[]{tmp.resolve(rootFile)});
            Assertions.assertThat((Collection)detectedFiles).contains((Object[])new Path[]{tmp.resolve(subFile)});
        }
    }

    @Test
    void testEmptyDirectory() throws IOException {
        Path rootDir = Paths.get("root", new String[0]);
        Path tmp = this.temporaryFolder;
        Files.createDirectory(tmp.resolve(rootDir), new FileAttribute[0]);
        try (FileUploads fileUploads = new FileUploads(tmp.resolve(rootDir));){
            Collection detectedFiles = fileUploads.getUploadedFiles();
            Assertions.assertThat((Collection)detectedFiles).isEmpty();
        }
    }

    @Test
    void testCleanup() throws IOException {
        Path rootDir = Paths.get("root", new String[0]);
        Path rootFile = rootDir.resolve("rootFile");
        Path subDir = rootDir.resolve("sub");
        Path subFile = subDir.resolve("subFile");
        Path tmp = this.temporaryFolder;
        Files.createDirectory(tmp.resolve(rootDir), new FileAttribute[0]);
        Files.createDirectory(tmp.resolve(subDir), new FileAttribute[0]);
        Files.createFile(tmp.resolve(rootFile), new FileAttribute[0]);
        Files.createFile(tmp.resolve(subFile), new FileAttribute[0]);
        try (FileUploads fileUploads = new FileUploads(tmp.resolve(rootDir));){
            Assertions.assertThat((boolean)Files.exists(tmp.resolve(rootDir), new LinkOption[0])).isTrue();
            Assertions.assertThat((boolean)Files.exists(tmp.resolve(subDir), new LinkOption[0])).isTrue();
            Assertions.assertThat((boolean)Files.exists(tmp.resolve(rootFile), new LinkOption[0])).isTrue();
            Assertions.assertThat((boolean)Files.exists(tmp.resolve(subFile), new LinkOption[0])).isTrue();
        }
        Assertions.assertThat((boolean)Files.exists(tmp.resolve(rootDir), new LinkOption[0])).isFalse();
        Assertions.assertThat((boolean)Files.exists(tmp.resolve(subDir), new LinkOption[0])).isFalse();
        Assertions.assertThat((boolean)Files.exists(tmp.resolve(rootFile), new LinkOption[0])).isFalse();
        Assertions.assertThat((boolean)Files.exists(tmp.resolve(subFile), new LinkOption[0])).isFalse();
    }
}

