/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerId;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.util.ResourceCounter;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class FineGrainedTaskManagerTrackerTest {
    private static final TaskExecutorConnection TASK_EXECUTOR_CONNECTION = new TaskExecutorConnection(ResourceID.generate(), (TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway());

    FineGrainedTaskManagerTrackerTest() {
    }

    @Test
    void testInitState() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        Assertions.assertThat((Collection)taskManagerTracker.getPendingTaskManagers()).isEmpty();
        Assertions.assertThat((Collection)taskManagerTracker.getRegisteredTaskManagers()).isEmpty();
    }

    @Test
    void testAddAndRemoveTaskManager() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        taskManagerTracker.addTaskManager(TASK_EXECUTOR_CONNECTION, ResourceProfile.ANY, ResourceProfile.ANY);
        Assertions.assertThat((Collection)taskManagerTracker.getRegisteredTaskManagers()).hasSize(1);
        Assertions.assertThat((Optional)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID())).isPresent();
        taskManagerTracker.removeTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID());
        Assertions.assertThat((Collection)taskManagerTracker.getRegisteredTaskManagers()).isEmpty();
    }

    @Test
    void testRemoveUnknownTaskManager() {
        Assertions.assertThatThrownBy(() -> {
            FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
            taskManagerTracker.removeTaskManager(new InstanceID());
        }).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testAddAndRemovePendingTaskManager() {
        PendingTaskManager pendingTaskManager = new PendingTaskManager(ResourceProfile.ANY, 1);
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        JobID jobId = new JobID();
        ResourceCounter resourceCounter = ResourceCounter.withResource((ResourceProfile)ResourceProfile.ANY, (int)1);
        taskManagerTracker.addPendingTaskManager(pendingTaskManager);
        taskManagerTracker.replaceAllPendingAllocations(Collections.singletonMap(pendingTaskManager.getPendingTaskManagerId(), Collections.singletonMap(jobId, resourceCounter)));
        Assertions.assertThat((Collection)taskManagerTracker.getPendingTaskManagers()).hasSize(1);
        Assertions.assertThat((Collection)taskManagerTracker.getPendingTaskManagersByTotalAndDefaultSlotResourceProfile(ResourceProfile.ANY, ResourceProfile.ANY)).hasSize(1);
        Map records = taskManagerTracker.removePendingTaskManager(pendingTaskManager.getPendingTaskManagerId());
        Assertions.assertThat((Collection)taskManagerTracker.getPendingTaskManagers()).isEmpty();
        Assertions.assertThat((Collection)taskManagerTracker.getPendingTaskManagersByTotalAndDefaultSlotResourceProfile(ResourceProfile.ANY, ResourceProfile.ANY)).isEmpty();
        Assertions.assertThat((Map)records).containsKey((Object)jobId);
        Assertions.assertThat((int)((ResourceCounter)records.get(jobId)).getResourceCount(ResourceProfile.ANY)).isEqualTo(1);
    }

    @Test
    void testRemoveUnknownPendingTaskManager() {
        Assertions.assertThatThrownBy(() -> {
            FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
            taskManagerTracker.removePendingTaskManager(PendingTaskManagerId.generate());
        }).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testSlotAllocation() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        AllocationID allocationId1 = new AllocationID();
        AllocationID allocationId2 = new AllocationID();
        JobID jobId = new JobID();
        taskManagerTracker.addTaskManager(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        taskManagerTracker.notifySlotStatus(allocationId1, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)3.0, (int)200), SlotState.PENDING);
        Assertions.assertThat((Optional)taskManagerTracker.getAllocatedOrPendingSlot(allocationId1)).isPresent();
        Assertions.assertThat((Optional)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID())).hasValueSatisfying(taskManagerInfo -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)taskManagerInfo.getAvailableResource()).isEqualTo((Object)ResourceProfile.fromResources((double)7.0, (int)800));
        });
        taskManagerTracker.notifySlotStatus(allocationId1, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)3.0, (int)200), SlotState.ALLOCATED);
        Assertions.assertThat((Optional)taskManagerTracker.getAllocatedOrPendingSlot(allocationId1)).isPresent();
        Assertions.assertThat((Optional)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID())).hasValueSatisfying(taskManagerInfo -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)taskManagerInfo.getAvailableResource()).isEqualTo((Object)ResourceProfile.fromResources((double)7.0, (int)800));
        });
        taskManagerTracker.notifySlotStatus(allocationId2, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)2.0, (int)300), SlotState.ALLOCATED);
        Assertions.assertThat((Optional)taskManagerTracker.getAllocatedOrPendingSlot(allocationId2)).isPresent();
        Assertions.assertThat((Optional)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID())).hasValueSatisfying(taskManagerInfo -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)taskManagerInfo.getAvailableResource()).isEqualTo((Object)ResourceProfile.fromResources((double)5.0, (int)500));
        });
    }

    @Test
    void testFreeSlot() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        AllocationID allocationId1 = new AllocationID();
        AllocationID allocationId2 = new AllocationID();
        JobID jobId = new JobID();
        taskManagerTracker.addTaskManager(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        taskManagerTracker.notifySlotStatus(allocationId1, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)3.0, (int)200), SlotState.PENDING);
        taskManagerTracker.notifySlotStatus(allocationId2, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)2.0, (int)300), SlotState.ALLOCATED);
        taskManagerTracker.notifySlotStatus(allocationId1, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)3.0, (int)200), SlotState.FREE);
        Assertions.assertThat((Optional)taskManagerTracker.getAllocatedOrPendingSlot(allocationId1)).isNotPresent();
        Assertions.assertThat((Optional)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID())).hasValueSatisfying(taskManagerInfo -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)taskManagerInfo.getAvailableResource()).isEqualTo((Object)ResourceProfile.fromResources((double)8.0, (int)700));
        });
        taskManagerTracker.notifySlotStatus(allocationId2, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)2.0, (int)300), SlotState.FREE);
        Assertions.assertThat((Optional)taskManagerTracker.getAllocatedOrPendingSlot(allocationId2)).isNotPresent();
        Assertions.assertThat((Optional)taskManagerTracker.getRegisteredTaskManager(TASK_EXECUTOR_CONNECTION.getInstanceID())).hasValueSatisfying(taskManagerInfo -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)taskManagerInfo.getAvailableResource()).isEqualTo((Object)totalResource);
        });
    }

    @Test
    void testFreeUnknownSlot() {
        Assertions.assertThatThrownBy(() -> {
            FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
            taskManagerTracker.notifySlotStatus(new AllocationID(), new JobID(), new InstanceID(), ResourceProfile.ANY, SlotState.FREE);
        }).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testRecordPendingAllocations() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        PendingTaskManager pendingTaskManager1 = new PendingTaskManager(ResourceProfile.ANY, 1);
        PendingTaskManager pendingTaskManager2 = new PendingTaskManager(ResourceProfile.ANY, 1);
        JobID jobId = new JobID();
        ResourceCounter resourceCounter = ResourceCounter.withResource((ResourceProfile)ResourceProfile.ANY, (int)1);
        taskManagerTracker.addPendingTaskManager(pendingTaskManager1);
        taskManagerTracker.addPendingTaskManager(pendingTaskManager2);
        taskManagerTracker.replaceAllPendingAllocations(Collections.singletonMap(pendingTaskManager1.getPendingTaskManagerId(), Collections.singletonMap(jobId, resourceCounter)));
        taskManagerTracker.replaceAllPendingAllocations(Collections.singletonMap(pendingTaskManager2.getPendingTaskManagerId(), Collections.singletonMap(jobId, resourceCounter)));
        Assertions.assertThat((Map)pendingTaskManager1.getPendingSlotAllocationRecords()).isEmpty();
        Assertions.assertThat((Map)pendingTaskManager2.getPendingSlotAllocationRecords()).contains(new Map.Entry[]{Assertions.entry((Object)jobId, (Object)ResourceCounter.withResource((ResourceProfile)ResourceProfile.ANY, (int)1))});
    }

    @Test
    void testPendingTaskManagerUnusedResources() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        ResourceProfile defaultSlotResource = ResourceProfile.fromResources((double)1.0, (int)100);
        PendingTaskManager pendingTaskManager = new PendingTaskManager(totalResource, 10);
        JobID jobId = new JobID();
        ResourceCounter resourceCounter = ResourceCounter.withResource((ResourceProfile)defaultSlotResource, (int)1);
        Assertions.assertThat((Object)pendingTaskManager.getUnusedResource()).isEqualTo((Object)totalResource);
        taskManagerTracker.addPendingTaskManager(pendingTaskManager);
        taskManagerTracker.replaceAllPendingAllocations(Collections.singletonMap(pendingTaskManager.getPendingTaskManagerId(), Collections.singletonMap(jobId, resourceCounter)));
        Assertions.assertThat((Object)pendingTaskManager.getUnusedResource()).isEqualTo((Object)totalResource.subtract(defaultSlotResource));
    }

    @Test
    void testGetStatistics() {
        FineGrainedTaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        ResourceProfile defaultSlotResource = ResourceProfile.fromResources((double)1.0, (int)100);
        AllocationID allocationId1 = new AllocationID();
        AllocationID allocationId2 = new AllocationID();
        JobID jobId = new JobID();
        taskManagerTracker.addTaskManager(TASK_EXECUTOR_CONNECTION, totalResource, defaultSlotResource);
        taskManagerTracker.notifySlotStatus(allocationId1, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), ResourceProfile.fromResources((double)3.0, (int)200), SlotState.ALLOCATED);
        taskManagerTracker.notifySlotStatus(allocationId2, jobId, TASK_EXECUTOR_CONNECTION.getInstanceID(), defaultSlotResource, SlotState.ALLOCATED);
        taskManagerTracker.addPendingTaskManager(new PendingTaskManager(ResourceProfile.fromResources((double)4.0, (int)200), 1));
        Assertions.assertThat((Object)taskManagerTracker.getFreeResource()).isEqualTo((Object)ResourceProfile.fromResources((double)6.0, (int)700));
        Assertions.assertThat((Object)taskManagerTracker.getRegisteredResource()).isEqualTo((Object)totalResource);
        Assertions.assertThat((int)taskManagerTracker.getNumberRegisteredSlots()).isEqualTo(10);
        Assertions.assertThat((int)taskManagerTracker.getNumberFreeSlots()).isEqualTo(8);
        Assertions.assertThat((Object)taskManagerTracker.getPendingResource()).isEqualTo((Object)ResourceProfile.fromResources((double)4.0, (int)200));
    }
}

