/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.TestingLeaderElection;
import org.apache.flink.runtime.resourcemanager.TestingResourceManagerService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ResourceManagerHATest {
    ResourceManagerHATest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGrantAndRevokeLeadership() throws Exception {
        TestingLeaderElection leaderElection = new TestingLeaderElection();
        TestingResourceManagerService resourceManagerService = TestingResourceManagerService.newBuilder().setRmLeaderElection(leaderElection).build();
        try {
            resourceManagerService.start();
            UUID leaderId = UUID.randomUUID();
            LeaderInformation confirmedLeaderInformation = resourceManagerService.isLeader(leaderId).join();
            Assertions.assertThat((Comparable)confirmedLeaderInformation.getLeaderSessionID()).isEqualTo((Object)leaderId);
            Assertions.assertThat(resourceManagerService.getResourceManagerFencingToken()).isPresent();
            Assertions.assertThat((Comparable)resourceManagerService.getResourceManagerFencingToken().get().toUUID()).isEqualTo((Object)leaderId);
            Optional<CompletableFuture<Void>> rmTerminationFutureOpt = resourceManagerService.getResourceManagerTerminationFuture();
            Assertions.assertThat(rmTerminationFutureOpt).isPresent();
            resourceManagerService.notLeader();
            rmTerminationFutureOpt.get().get();
            resourceManagerService.rethrowFatalErrorIfAny();
        }
        finally {
            resourceManagerService.cleanUp();
        }
    }
}

