/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.util.Random;
import org.apache.flink.runtime.operators.testutils.types.IntPair;
import org.apache.flink.util.MutableObjectIterator;

public class RandomIntPairGenerator
implements MutableObjectIterator<IntPair> {
    private final long seed;
    private final long numRecords;
    private Random rnd;
    private long count;

    public RandomIntPairGenerator(long seed) {
        this(seed, Long.MAX_VALUE);
    }

    public RandomIntPairGenerator(long seed, long numRecords) {
        this.seed = seed;
        this.numRecords = numRecords;
        this.rnd = new Random(seed);
    }

    public IntPair next(IntPair reuse) {
        if (this.count++ < this.numRecords) {
            reuse.setKey(this.rnd.nextInt());
            reuse.setValue(this.rnd.nextInt());
            return reuse;
        }
        return null;
    }

    public IntPair next() {
        if (this.count++ < this.numRecords) {
            return new IntPair(this.rnd.nextInt(), this.rnd.nextInt());
        }
        return null;
    }

    public void reset() {
        this.rnd = new Random(this.seed);
        this.count = 0L;
    }
}

