/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.checkpoint;

import java.io.File;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class DeclineCheckpointTest {
    @TempDir
    private Path tempDir;

    DeclineCheckpointTest() {
    }

    @Test
    void testDeclineCheckpointWithUserExceptionCanBeDeserializedWithoutUserClass() throws Exception {
        String className = "UserException";
        URLClassLoader userClassLoader = ClassLoaderUtils.compileAndLoadJava((File)TempDirUtils.newFolder((Path)this.tempDir), (String)"UserException.java", (String)String.format("public class %s extends RuntimeException { public %s() {super(\"UserMessage\");} }", "UserException", "UserException"));
        Throwable userException = (Throwable)Class.forName("UserException", false, userClassLoader).newInstance();
        CheckpointException checkpointException = new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED, userException);
        byte[] serializedCheckpointMessage = InstantiationUtil.serializeObject((Object)new DeclineCheckpoint(new JobID(), ExecutionGraphTestUtils.createExecutionAttemptId(), 1L, checkpointException));
        DeclineCheckpoint deserializedCheckpointMessage = (DeclineCheckpoint)InstantiationUtil.deserializeObject((byte[])serializedCheckpointMessage, (ClassLoader)ClassLoader.getSystemClassLoader());
        CheckpointException throwable = deserializedCheckpointMessage.getSerializedCheckpointException().unwrap();
        Assertions.assertThat((Throwable)throwable).isInstanceOf(CheckpointException.class);
        Optional throwableWithMessage = ExceptionUtils.findThrowableWithMessage((Throwable)throwable, (String)userException.getMessage());
        ((OptionalAssert)Assertions.assertThat((Optional)throwableWithMessage).isPresent()).hasValueSatisfying(throwable1 -> Assertions.assertThat((Throwable)throwable1).hasMessage(String.format("%s: %s", userException.getClass().getName(), userException.getMessage())));
    }
}

