/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import java.util.UUID;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.TestingListener;
import org.apache.flink.runtime.leaderretrieval.DefaultLeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriverFactory;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.TestingLeaderRetrievalDriver;
import org.apache.flink.util.function.RunnableWithException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultLeaderRetrievalServiceTest {
    private static final String TEST_URL = "pekko://user/jobmanager";

    DefaultLeaderRetrievalServiceTest() {
    }

    @Test
    void testNotifyLeaderAddress() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    LeaderInformation newLeader = LeaderInformation.known((UUID)UUID.randomUUID(), (String)DefaultLeaderRetrievalServiceTest.TEST_URL);
                    this.testingLeaderRetrievalDriver.onUpdate(newLeader);
                    this.testingListener.waitForNewLeader();
                    Assertions.assertThat((Comparable)this.testingListener.getLeaderSessionID()).isEqualTo((Object)newLeader.getLeaderSessionID());
                    Assertions.assertThat((String)this.testingListener.getAddress()).isEqualTo(newLeader.getLeaderAddress());
                });
            }
        };
    }

    @Test
    void testNotifyLeaderAddressEmpty() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    LeaderInformation newLeader = LeaderInformation.known((UUID)UUID.randomUUID(), (String)DefaultLeaderRetrievalServiceTest.TEST_URL);
                    this.testingLeaderRetrievalDriver.onUpdate(newLeader);
                    this.testingListener.waitForNewLeader();
                    this.testingLeaderRetrievalDriver.onUpdate(LeaderInformation.empty());
                    this.testingListener.waitForEmptyLeaderInformation();
                    Assertions.assertThat((Comparable)this.testingListener.getLeaderSessionID()).isNull();
                    Assertions.assertThat((String)this.testingListener.getAddress()).isNull();
                });
            }
        };
    }

    @Test
    void testErrorForwarding() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    Exception testException = new Exception("test exception");
                    this.testingLeaderRetrievalDriver.onFatalError(testException);
                    this.testingListener.waitForError();
                    Assertions.assertThat((Throwable)this.testingListener.getError()).hasCause((Throwable)testException);
                });
            }
        };
    }

    @Test
    void testErrorIsIgnoredAfterBeingStop() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    Exception testException = new Exception("test exception");
                    this.leaderRetrievalService.stop();
                    this.testingLeaderRetrievalDriver.onFatalError(testException);
                    Assertions.assertThat((Throwable)this.testingListener.getError()).isNull();
                });
            }
        };
    }

    @Test
    void testNotifyLeaderAddressOnlyWhenLeaderTrulyChanged() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    LeaderInformation newLeader = LeaderInformation.known((UUID)UUID.randomUUID(), (String)DefaultLeaderRetrievalServiceTest.TEST_URL);
                    this.testingLeaderRetrievalDriver.onUpdate(newLeader);
                    Assertions.assertThat((int)this.testingListener.getLeaderEventQueueSize()).isOne();
                    this.testingLeaderRetrievalDriver.onUpdate(newLeader);
                    Assertions.assertThat((int)this.testingListener.getLeaderEventQueueSize()).isOne();
                    this.testingLeaderRetrievalDriver.onUpdate(LeaderInformation.known((UUID)UUID.randomUUID(), (String)"pekko://user/jobmanager1"));
                    Assertions.assertThat((int)this.testingListener.getLeaderEventQueueSize()).isEqualTo(2);
                });
            }
        };
    }

    private static class Context {
        private final TestingLeaderRetrievalDriver.TestingLeaderRetrievalDriverFactory leaderRetrievalDriverFactory = new TestingLeaderRetrievalDriver.TestingLeaderRetrievalDriverFactory();
        final DefaultLeaderRetrievalService leaderRetrievalService = new DefaultLeaderRetrievalService((LeaderRetrievalDriverFactory)this.leaderRetrievalDriverFactory);
        final TestingListener testingListener = new TestingListener();
        TestingLeaderRetrievalDriver testingLeaderRetrievalDriver;

        private Context() {
        }

        void runTest(RunnableWithException testMethod) throws Exception {
            this.leaderRetrievalService.start((LeaderRetrievalListener)this.testingListener);
            this.testingLeaderRetrievalDriver = this.leaderRetrievalDriverFactory.getCurrentRetrievalDriver();
            Assertions.assertThat((Object)this.testingLeaderRetrievalDriver).isNotNull();
            testMethod.run();
            this.leaderRetrievalService.stop();
        }
    }
}

