/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.client.JobCancellationException;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.SerializedThrowable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JobResultTest {
    JobResultTest() {
    }

    @Test
    void testNetRuntimeMandatory() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new JobResult.Builder().jobId(new JobID()).build()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("netRuntime must be greater than or equals 0");
    }

    @Test
    void testIsNotSuccess() {
        JobResult jobResult = new JobResult.Builder().jobId(new JobID()).serializedThrowable(new SerializedThrowable((Throwable)new RuntimeException())).netRuntime(Long.MAX_VALUE).build();
        Assertions.assertThat((boolean)jobResult.isSuccess()).isFalse();
    }

    @Test
    void testIsSuccess() {
        JobResult jobResult = new JobResult.Builder().jobId(new JobID()).netRuntime(Long.MAX_VALUE).build();
        Assertions.assertThat((boolean)jobResult.isSuccess()).isTrue();
    }

    @Test
    void testCancelledJobIsFailureResult() {
        JobResult jobResult = JobResult.createFrom((AccessExecutionGraph)new ArchivedExecutionGraphBuilder().setJobID(new JobID()).setState(JobStatus.CANCELED).build());
        Assertions.assertThat((boolean)jobResult.isSuccess()).isFalse();
    }

    @Test
    void testFailedJobIsFailureResult() {
        JobResult jobResult = JobResult.createFrom((AccessExecutionGraph)new ArchivedExecutionGraphBuilder().setJobID(new JobID()).setState(JobStatus.FAILED).setFailureCause(new ErrorInfo((Throwable)new FlinkException("Test exception"), 42L)).build());
        Assertions.assertThat((boolean)jobResult.isSuccess()).isFalse();
    }

    @Test
    void testCancelledJobThrowsJobCancellationException() {
        FlinkException cause = new FlinkException("Test exception");
        JobResult jobResult = JobResult.createFrom((AccessExecutionGraph)new ArchivedExecutionGraphBuilder().setJobID(new JobID()).setState(JobStatus.CANCELED).setFailureCause(new ErrorInfo((Throwable)cause, 42L)).build());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> jobResult.toJobExecutionResult(this.getClass().getClassLoader())).isInstanceOf(JobCancellationException.class)).hasNoCause();
    }

    @Test
    void testFailedJobThrowsJobExecutionException() {
        FlinkException cause = new FlinkException("Test exception");
        JobResult jobResult = JobResult.createFrom((AccessExecutionGraph)new ArchivedExecutionGraphBuilder().setJobID(new JobID()).setState(JobStatus.FAILED).setFailureCause(new ErrorInfo((Throwable)cause, 42L)).build());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> jobResult.toJobExecutionResult(this.getClass().getClassLoader())).isInstanceOf(JobExecutionException.class)).cause().isEqualTo((Object)cause);
    }

    @Test
    void testFailureResultRequiresFailureCause() {
        Assertions.assertThatThrownBy(() -> JobResult.createFrom((AccessExecutionGraph)new ArchivedExecutionGraphBuilder().setJobID(new JobID()).setState(JobStatus.FAILED).build())).isInstanceOf(NullPointerException.class);
    }
}

