/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.jsonplan;

import java.util.Iterator;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.jsonplan.JsonPlanGenerator;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.TextNode;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.junit.Assert;
import org.junit.Test;

public class JsonGeneratorTest {
    @Test
    public void testGeneratorWithoutAnyAttachements() {
        try {
            JobVertex source1 = new JobVertex("source 1");
            JobVertex source2 = new JobVertex("source 2");
            source2.setInvokableClass(DummyInvokable.class);
            JobVertex source3 = new JobVertex("source 3");
            JobVertex intermediate1 = new JobVertex("intermediate 1");
            JobVertex intermediate2 = new JobVertex("intermediate 2");
            JobVertex join1 = new JobVertex("join 1");
            JobVertex join2 = new JobVertex("join 2");
            JobVertex sink1 = new JobVertex("sink 1");
            JobVertex sink2 = new JobVertex("sink 2");
            intermediate1.connectNewDataSetAsInput(source1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            intermediate2.connectNewDataSetAsInput(source2, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
            join1.connectNewDataSetAsInput(intermediate1, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
            join1.connectNewDataSetAsInput(intermediate2, DistributionPattern.ALL_TO_ALL, ResultPartitionType.BLOCKING);
            join2.connectNewDataSetAsInput(join1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            join2.connectNewDataSetAsInput(source3, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
            sink1.connectNewDataSetAsInput(join2, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            sink2.connectNewDataSetAsInput(join1, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
            JobGraph jg = JobGraphTestUtils.batchJobGraph(source1, source2, source3, intermediate1, intermediate2, join1, join2, sink1, sink2);
            String plan = JsonPlanGenerator.generatePlan((JobGraph)jg);
            Assert.assertNotNull((Object)plan);
            ObjectMapper m = JacksonMapperFactory.createObjectMapper();
            JsonNode rootNode = m.readTree(plan);
            Assert.assertEquals((Object)new TextNode(jg.getJobID().toString()), (Object)rootNode.get("jid"));
            Assert.assertEquals((Object)new TextNode(jg.getName()), (Object)rootNode.get("name"));
            Assert.assertEquals((Object)new TextNode(jg.getJobType().name()), (Object)rootNode.get("type"));
            Assert.assertTrue((boolean)rootNode.path("nodes").isArray());
            Iterator iter = rootNode.path("nodes").elements();
            while (iter.hasNext()) {
                JsonNode next = (JsonNode)iter.next();
                JsonNode idNode = next.get("id");
                Assert.assertNotNull((Object)idNode);
                Assert.assertTrue((boolean)idNode.isTextual());
                this.checkVertexExists(idNode.asText(), jg);
                String description = next.get("description").asText();
                Assert.assertTrue((description.startsWith("source") || description.startsWith("sink") || description.startsWith("intermediate") || description.startsWith("join") ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void checkVertexExists(String vertexId, JobGraph graph) {
        JobVertexID id = JobVertexID.fromHexString((String)vertexId);
        for (JobVertex vertex : graph.getVertices()) {
            if (!vertex.getID().equals((Object)id)) continue;
            return;
        }
        Assert.fail((String)("could not find vertex with id " + vertexId + " in JobGraph"));
    }
}

