/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import org.apache.flink.runtime.io.network.netty.CreditBasedSequenceNumberingViewReader;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.partition.NoOpResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.TestingResultPartition;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.embedded.EmbeddedChannel;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CreditBasedSequenceNumberingViewReaderTest {
    CreditBasedSequenceNumberingViewReaderTest() {
    }

    @Test
    void testResumeConsumption() throws Exception {
        int numCredits = 2;
        CreditBasedSequenceNumberingViewReader reader1 = CreditBasedSequenceNumberingViewReaderTest.createNetworkSequenceViewReader(numCredits);
        reader1.resumeConsumption();
        Assertions.assertThat((int)reader1.getNumCreditsAvailable()).isEqualTo(numCredits);
        reader1.addCredit(numCredits);
        reader1.resumeConsumption();
        Assertions.assertThat((int)reader1.getNumCreditsAvailable()).isEqualTo(2 * numCredits);
        CreditBasedSequenceNumberingViewReader reader2 = CreditBasedSequenceNumberingViewReaderTest.createNetworkSequenceViewReader(0);
        reader2.addCredit(numCredits);
        Assertions.assertThat((int)reader2.getNumCreditsAvailable()).isEqualTo(numCredits);
        reader2.resumeConsumption();
        Assertions.assertThat((int)reader2.getNumCreditsAvailable()).isZero();
    }

    @Test
    void testNeedAnnounceBacklog() throws Exception {
        int numCredits = 2;
        CreditBasedSequenceNumberingViewReader reader1 = CreditBasedSequenceNumberingViewReaderTest.createNetworkSequenceViewReader(numCredits);
        Assertions.assertThat((boolean)reader1.needAnnounceBacklog()).isFalse();
        reader1.addCredit(-numCredits);
        Assertions.assertThat((boolean)reader1.needAnnounceBacklog()).isFalse();
        CreditBasedSequenceNumberingViewReader reader2 = CreditBasedSequenceNumberingViewReaderTest.createNetworkSequenceViewReader(0);
        Assertions.assertThat((boolean)reader2.needAnnounceBacklog()).isTrue();
        reader2.addCredit(numCredits);
        Assertions.assertThat((boolean)reader2.needAnnounceBacklog()).isFalse();
        reader2.addCredit(-numCredits);
        Assertions.assertThat((boolean)reader2.needAnnounceBacklog()).isTrue();
    }

    @Test
    void testPeekNextBufferSubpartitionId() throws Exception {
        int numCredits = 2;
        CreditBasedSequenceNumberingViewReader reader = CreditBasedSequenceNumberingViewReaderTest.createNetworkSequenceViewReader(numCredits);
        Assertions.assertThat((int)reader.peekNextBufferSubpartitionId()).isZero();
    }

    private static CreditBasedSequenceNumberingViewReader createNetworkSequenceViewReader(int initialCredit) throws Exception {
        PartitionRequestQueue queue = new PartitionRequestQueue();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{queue});
        channel.close();
        CreditBasedSequenceNumberingViewReader reader = new CreditBasedSequenceNumberingViewReader(new InputChannelID(), initialCredit, queue);
        reader.notifySubpartitionsCreated((ResultPartition)TestingResultPartition.newBuilder().setCreateSubpartitionViewFunction((index, listener) -> new NoOpResultSubpartitionView()).build(), new ResultSubpartitionIndexSet(0));
        return reader;
    }
}

