/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.SavepointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CheckpointSerializationTest {
    private static final byte[] STORAGE_LOCATION_REF = new byte[]{15, 52, 52, 11, 0, 0, 0, 0, -1, -23, -19, 35};

    CheckpointSerializationTest() {
    }

    @Test
    void testSuspendingCheckpointBarrierSerialization() throws Exception {
        CheckpointOptions suspendSavepointToSerialize = new CheckpointOptions((SnapshotType)SavepointType.suspend((SavepointFormatType)SavepointFormatType.CANONICAL), new CheckpointStorageLocationReference(STORAGE_LOCATION_REF));
        CheckpointSerializationTest.testCheckpointBarrierSerialization(suspendSavepointToSerialize);
    }

    @Test
    void testSavepointBarrierSerialization() throws Exception {
        CheckpointOptions savepointToSerialize = new CheckpointOptions((SnapshotType)SavepointType.savepoint((SavepointFormatType)SavepointFormatType.CANONICAL), new CheckpointStorageLocationReference(STORAGE_LOCATION_REF));
        CheckpointSerializationTest.testCheckpointBarrierSerialization(savepointToSerialize);
    }

    @Test
    void testCheckpointBarrierSerialization() throws Exception {
        CheckpointOptions checkpointToSerialize = new CheckpointOptions((SnapshotType)CheckpointType.CHECKPOINT, new CheckpointStorageLocationReference(STORAGE_LOCATION_REF));
        CheckpointSerializationTest.testCheckpointBarrierSerialization(checkpointToSerialize);
    }

    @Test
    void testFullCheckpointBarrierSerialization() throws Exception {
        CheckpointOptions checkpointToSerialize = new CheckpointOptions((SnapshotType)CheckpointType.FULL_CHECKPOINT, new CheckpointStorageLocationReference(STORAGE_LOCATION_REF));
        CheckpointSerializationTest.testCheckpointBarrierSerialization(checkpointToSerialize);
    }

    @Test
    void testCheckpointWithDefaultLocationSerialization() throws Exception {
        CheckpointOptions checkpointToSerialize = CheckpointOptions.forCheckpointWithDefaultLocation();
        CheckpointSerializationTest.testCheckpointBarrierSerialization(checkpointToSerialize);
    }

    private static void testCheckpointBarrierSerialization(CheckpointOptions options) throws IOException {
        long checkpointId = 2147606770L;
        long timestamp = 2147484875L;
        CheckpointBarrier barrierBeforeSerialization = new CheckpointBarrier(2147606770L, 2147484875L, options);
        CheckpointBarrier barrierAfterDeserialization = CheckpointSerializationTest.serializeAndDeserializeCheckpointBarrier(barrierBeforeSerialization);
        Assertions.assertThat((Object)barrierAfterDeserialization).isEqualTo((Object)barrierBeforeSerialization);
    }

    private static CheckpointBarrier serializeAndDeserializeCheckpointBarrier(CheckpointBarrier barrierUnderTest) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ByteBuffer serialized = EventSerializer.toSerializedEvent((AbstractEvent)barrierUnderTest);
        CheckpointBarrier deserialized = (CheckpointBarrier)EventSerializer.fromSerializedEvent((ByteBuffer)serialized, (ClassLoader)cl);
        Assertions.assertThat((boolean)serialized.hasRemaining()).isFalse();
        return deserialized;
    }
}

