/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.EOFException;
import java.util.List;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.disk.FileChannelInputView;
import org.apache.flink.runtime.io.disk.FileChannelOutputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.PairGenerator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FileChannelStreamsITCase {
    private static final long SEED = 649180756312423613L;
    private static final int KEY_MAX = Integer.MAX_VALUE;
    private static final int VALUE_SHORT_LENGTH = 114;
    private static final int VALUE_LONG_LENGTH = 114688;
    private static final int NUM_PAIRS_SHORT = 1000000;
    private static final int NUM_PAIRS_LONG = 3000;
    private static final int MEMORY_PAGE_SIZE = 32768;
    private static final int NUM_MEMORY_SEGMENTS = 3;
    private IOManager ioManager;
    private MemoryManager memManager;

    FileChannelStreamsITCase() {
    }

    @BeforeEach
    void beforeTest() {
        this.memManager = MemoryManagerBuilder.newBuilder().setMemorySize(98304L).setPageSize(32768).build();
        this.ioManager = new IOManagerAsync();
    }

    @AfterEach
    void afterTest() throws Exception {
        this.ioManager.close();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.memManager.verifyEmpty()).withFailMessage("The memory has not been properly released", new Object[0])).isTrue();
    }

    @Test
    void testWriteReadSmallRecords() throws Exception {
        List memory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
        PairGenerator generator = new PairGenerator(649180756312423613L, Integer.MAX_VALUE, 114, PairGenerator.KeyMode.RANDOM, PairGenerator.ValueMode.RANDOM_LENGTH);
        FileIOChannel.ID channel = this.ioManager.createChannel();
        BlockChannelWriter writer = this.ioManager.createBlockChannelWriter(channel);
        FileChannelOutputView outView = new FileChannelOutputView(writer, this.memManager, memory, 32768);
        PairGenerator.Pair pair = new PairGenerator.Pair();
        for (int i = 0; i < 1000000; ++i) {
            generator.next(pair);
            pair.write((DataOutputView)outView);
        }
        outView.close();
        List readMemory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
        BlockChannelReader reader = this.ioManager.createBlockChannelReader(channel);
        FileChannelInputView inView = new FileChannelInputView(reader, this.memManager, readMemory, outView.getBytesInLatestSegment());
        generator.reset();
        PairGenerator.Pair readPair = new PairGenerator.Pair();
        for (int i = 0; i < 1000000; ++i) {
            generator.next(pair);
            readPair.read((DataInputView)inView);
            ((ObjectAssert)Assertions.assertThat((Object)readPair).withFailMessage("The re-generated and the read record do not match.", new Object[0])).isEqualTo((Object)pair);
        }
        inView.close();
        reader.deleteChannel();
    }

    @Test
    void testWriteAndReadLongRecords() throws Exception {
        List memory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
        PairGenerator generator = new PairGenerator(649180756312423613L, Integer.MAX_VALUE, 114688, PairGenerator.KeyMode.RANDOM, PairGenerator.ValueMode.RANDOM_LENGTH);
        FileIOChannel.ID channel = this.ioManager.createChannel();
        BlockChannelWriter writer = this.ioManager.createBlockChannelWriter(channel);
        FileChannelOutputView outView = new FileChannelOutputView(writer, this.memManager, memory, 32768);
        PairGenerator.Pair pair = new PairGenerator.Pair();
        for (int i = 0; i < 3000; ++i) {
            generator.next(pair);
            pair.write((DataOutputView)outView);
        }
        outView.close();
        List readMemory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
        BlockChannelReader reader = this.ioManager.createBlockChannelReader(channel);
        FileChannelInputView inView = new FileChannelInputView(reader, this.memManager, readMemory, outView.getBytesInLatestSegment());
        generator.reset();
        PairGenerator.Pair readPair = new PairGenerator.Pair();
        for (int i = 0; i < 3000; ++i) {
            generator.next(pair);
            readPair.read((DataInputView)inView);
            ((ObjectAssert)Assertions.assertThat((Object)readPair).withFailMessage("The re-generated and the read record do not match.", new Object[0])).isEqualTo((Object)pair);
        }
        inView.close();
        reader.deleteChannel();
    }

    @Test
    void testReadTooMany() throws Exception {
        List memory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
        PairGenerator generator = new PairGenerator(649180756312423613L, Integer.MAX_VALUE, 114, PairGenerator.KeyMode.RANDOM, PairGenerator.ValueMode.RANDOM_LENGTH);
        FileIOChannel.ID channel = this.ioManager.createChannel();
        BlockChannelWriter writer = this.ioManager.createBlockChannelWriter(channel);
        FileChannelOutputView outView = new FileChannelOutputView(writer, this.memManager, memory, 32768);
        PairGenerator.Pair pair = new PairGenerator.Pair();
        for (int i = 0; i < 1000000; ++i) {
            generator.next(pair);
            pair.write((DataOutputView)outView);
        }
        outView.close();
        List readMemory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
        BlockChannelReader reader = this.ioManager.createBlockChannelReader(channel);
        FileChannelInputView inView = new FileChannelInputView(reader, this.memManager, readMemory, outView.getBytesInLatestSegment());
        generator.reset();
        PairGenerator.Pair readPair = new PairGenerator.Pair();
        for (int i = 0; i < 1000000; ++i) {
            generator.next(pair);
            readPair.read((DataInputView)inView);
            ((ObjectAssert)Assertions.assertThat((Object)readPair).withFailMessage("The re-generated and the read record do not match.", new Object[0])).isEqualTo((Object)pair);
        }
        generator.next(pair);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> readPair.read((DataInputView)inView)).withFailMessage("Read too much, expected EOFException.", new Object[0])).isInstanceOf(EOFException.class);
        inView.close();
        reader.deleteChannel();
    }

    @Test
    void testWriteReadOneBufferOnly() throws Exception {
        List memory = this.memManager.allocatePages((Object)new DummyInvokable(), 1);
        PairGenerator generator = new PairGenerator(649180756312423613L, Integer.MAX_VALUE, 114, PairGenerator.KeyMode.RANDOM, PairGenerator.ValueMode.RANDOM_LENGTH);
        FileIOChannel.ID channel = this.ioManager.createChannel();
        BlockChannelWriter writer = this.ioManager.createBlockChannelWriter(channel);
        FileChannelOutputView outView = new FileChannelOutputView(writer, this.memManager, memory, 32768);
        PairGenerator.Pair pair = new PairGenerator.Pair();
        for (int i = 0; i < 1000000; ++i) {
            generator.next(pair);
            pair.write((DataOutputView)outView);
        }
        outView.close();
        List readMemory = this.memManager.allocatePages((Object)new DummyInvokable(), 1);
        BlockChannelReader reader = this.ioManager.createBlockChannelReader(channel);
        FileChannelInputView inView = new FileChannelInputView(reader, this.memManager, readMemory, outView.getBytesInLatestSegment());
        generator.reset();
        PairGenerator.Pair readPair = new PairGenerator.Pair();
        for (int i = 0; i < 1000000; ++i) {
            generator.next(pair);
            readPair.read((DataInputView)inView);
            ((ObjectAssert)Assertions.assertThat((Object)readPair).withFailMessage("The re-generated and the read record do not match.", new Object[0])).isEqualTo((Object)pair);
        }
        inView.close();
        reader.deleteChannel();
    }

    @Test
    void testWriteReadNotAll() throws Exception {
        List memory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
        PairGenerator generator = new PairGenerator(649180756312423613L, Integer.MAX_VALUE, 114, PairGenerator.KeyMode.RANDOM, PairGenerator.ValueMode.RANDOM_LENGTH);
        FileIOChannel.ID channel = this.ioManager.createChannel();
        BlockChannelWriter writer = this.ioManager.createBlockChannelWriter(channel);
        FileChannelOutputView outView = new FileChannelOutputView(writer, this.memManager, memory, 32768);
        PairGenerator.Pair pair = new PairGenerator.Pair();
        for (int i = 0; i < 1000000; ++i) {
            generator.next(pair);
            pair.write((DataOutputView)outView);
        }
        outView.close();
        List readMemory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
        BlockChannelReader reader = this.ioManager.createBlockChannelReader(channel);
        FileChannelInputView inView = new FileChannelInputView(reader, this.memManager, readMemory, outView.getBytesInLatestSegment());
        generator.reset();
        PairGenerator.Pair readPair = new PairGenerator.Pair();
        for (int i = 0; i < 500000; ++i) {
            generator.next(pair);
            readPair.read((DataInputView)inView);
            ((ObjectAssert)Assertions.assertThat((Object)readPair).withFailMessage("The re-generated and the read record do not match.", new Object[0])).isEqualTo((Object)pair);
        }
        inView.close();
        reader.deleteChannel();
    }
}

