/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.executiongraph.failover.FailureRateRestartBackoffTimeStrategy;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FailureRateRestartBackoffTimeStrategyTest {
    private final Exception failure = new Exception();

    FailureRateRestartBackoffTimeStrategyTest() {
    }

    @Test
    void testManyFailuresWithinRate() {
        int numFailures = 3;
        long intervalMS = 1L;
        ManualClock clock = new ManualClock();
        FailureRateRestartBackoffTimeStrategy restartStrategy = new FailureRateRestartBackoffTimeStrategy((Clock)clock, 1, 1L, 0L);
        for (int failuresLeft = 3; failuresLeft > 0; --failuresLeft) {
            restartStrategy.notifyFailure((Throwable)this.failure);
            Assertions.assertThat((boolean)restartStrategy.canRestart()).isTrue();
            clock.advanceTime(2L, TimeUnit.MILLISECONDS);
        }
        Assertions.assertThat((boolean)restartStrategy.canRestart()).isTrue();
    }

    @Test
    void testFailuresExceedingRate() {
        int numFailures = 3;
        long intervalMS = 10000L;
        FailureRateRestartBackoffTimeStrategy restartStrategy = new FailureRateRestartBackoffTimeStrategy((Clock)new ManualClock(), 3, 10000L, 0L);
        for (int failuresLeft = 3; failuresLeft > 0; --failuresLeft) {
            restartStrategy.notifyFailure((Throwable)this.failure);
            Assertions.assertThat((boolean)restartStrategy.canRestart()).isTrue();
        }
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assertions.assertThat((boolean)restartStrategy.canRestart()).isFalse();
    }

    @Test
    void testBackoffTime() {
        long backoffTimeMS = 10000L;
        FailureRateRestartBackoffTimeStrategy restartStrategy = new FailureRateRestartBackoffTimeStrategy((Clock)new ManualClock(), 1, 1L, 10000L);
        Assertions.assertThat((long)restartStrategy.getBackoffTime()).isEqualTo(10000L);
    }
}

