/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.runtime.executiongraph.AllVerticesIterator;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class AllVerticesIteratorTest {
    @RegisterExtension
    static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorExtension();

    AllVerticesIteratorTest() {
    }

    @Test
    void testAllVertices() {
        try {
            JobVertex v1 = new JobVertex("v1");
            JobVertex v2 = new JobVertex("v2");
            JobVertex v3 = new JobVertex("v3");
            JobVertex v4 = new JobVertex("v4");
            v1.setInvokableClass(AbstractInvokable.class);
            v2.setInvokableClass(AbstractInvokable.class);
            v3.setInvokableClass(AbstractInvokable.class);
            v4.setInvokableClass(AbstractInvokable.class);
            v1.setParallelism(1);
            v2.setParallelism(7);
            v3.setParallelism(3);
            v4.setParallelism(2);
            DefaultExecutionGraph eg = ExecutionGraphTestUtils.createExecutionGraph((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor(), v1, v2, v3, v4);
            ExecutionJobVertex ejv1 = eg.getJobVertex(v1.getID());
            ExecutionJobVertex ejv2 = eg.getJobVertex(v2.getID());
            ExecutionJobVertex ejv3 = eg.getJobVertex(v3.getID());
            ExecutionJobVertex ejv4 = eg.getJobVertex(v4.getID());
            AllVerticesIterator iter = new AllVerticesIterator(Arrays.asList(ejv1, ejv2, ejv3, ejv4).iterator());
            int numReturned = 0;
            while (iter.hasNext()) {
                iter.hasNext();
                Assertions.assertThat((Object)iter.next()).isNotNull();
                ++numReturned;
            }
            Assertions.assertThat((int)numReturned).isEqualTo(13);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

