/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.util.Properties;
import org.apache.flink.runtime.entrypoint.EntrypointClusterConfiguration;
import org.apache.flink.runtime.entrypoint.EntrypointClusterConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class EntrypointClusterConfigurationParserFactoryTest
extends TestLogger {
    private static final CommandLineParser<EntrypointClusterConfiguration> commandLineParser = new CommandLineParser((ParserResultFactory)new EntrypointClusterConfigurationParserFactory());

    @Test
    public void testEntrypointClusterConfigurationParsing() throws FlinkParseException {
        String configDir = "/foo/bar";
        int restPort = 1234;
        String key = "key";
        String value = "value";
        String arg1 = "arg1";
        String arg2 = "arg2";
        String[] args = new String[]{"--configDir", "/foo/bar", "--executionMode", "cluster", "--host", "localhost", "-r", String.valueOf(1234), String.format("-D%s=%s", "key", "value"), "arg1", "arg2"};
        EntrypointClusterConfiguration clusterConfiguration = (EntrypointClusterConfiguration)commandLineParser.parse(args);
        Assert.assertThat((Object)clusterConfiguration.getConfigDir(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"/foo/bar")));
        Assert.assertThat((Object)clusterConfiguration.getRestPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1234)));
        Properties dynamicProperties = clusterConfiguration.getDynamicProperties();
        Assert.assertThat((Object)dynamicProperties, (Matcher)Matchers.hasEntry((Object)"key", (Object)"value"));
        Assert.assertThat((Object)clusterConfiguration.getArgs(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"arg1", "arg2"}));
    }

    @Test
    public void testOnlyRequiredArguments() throws FlinkParseException {
        String configDir = "/foo/bar";
        String[] args = new String[]{"--configDir", "/foo/bar"};
        EntrypointClusterConfiguration clusterConfiguration = (EntrypointClusterConfiguration)commandLineParser.parse(args);
        Assert.assertThat((Object)clusterConfiguration.getConfigDir(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"/foo/bar")));
        Assert.assertThat((Object)clusterConfiguration.getRestPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)-1)));
    }

    @Test(expected=FlinkParseException.class)
    public void testMissingRequiredArgument() throws FlinkParseException {
        String[] args = new String[]{};
        commandLineParser.parse(args);
    }
}

