/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.core.testutils.FlinkCompletableFutureAssert;
import org.apache.flink.runtime.concurrent.UnsupportedOperationExecutor;
import org.apache.flink.runtime.dispatcher.DefaultJobManagerRunnerRegistry;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerRegistry;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.TestingJobManagerRunner;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DefaultJobManagerRunnerRegistryTest {
    private JobManagerRunnerRegistry testInstance;

    DefaultJobManagerRunnerRegistryTest() {
    }

    @BeforeEach
    void setup() {
        this.testInstance = new DefaultJobManagerRunnerRegistry(4);
    }

    @Test
    void testIsRegistered() {
        JobID jobId = new JobID();
        this.testInstance.register((JobManagerRunner)TestingJobManagerRunner.newBuilder().setJobId(jobId).build());
        Assertions.assertThat((boolean)this.testInstance.isRegistered(jobId)).isTrue();
    }

    @Test
    void testIsNotRegistered() {
        Assertions.assertThat((boolean)this.testInstance.isRegistered(new JobID())).isFalse();
    }

    @Test
    void testRegister() {
        JobID jobId = new JobID();
        this.testInstance.register((JobManagerRunner)TestingJobManagerRunner.newBuilder().setJobId(jobId).build());
        Assertions.assertThat((boolean)this.testInstance.isRegistered(jobId)).isTrue();
    }

    @Test
    void testRegisteringTwiceCausesFailure() {
        JobID jobId = new JobID();
        this.testInstance.register((JobManagerRunner)TestingJobManagerRunner.newBuilder().setJobId(jobId).build());
        Assertions.assertThat((boolean)this.testInstance.isRegistered(jobId)).isTrue();
        Assertions.assertThatThrownBy(() -> this.testInstance.register((JobManagerRunner)TestingJobManagerRunner.newBuilder().setJobId(jobId).build())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testGet() {
        JobID jobId = new JobID();
        TestingJobManagerRunner jobManagerRunner = TestingJobManagerRunner.newBuilder().setJobId(jobId).build();
        this.testInstance.register((JobManagerRunner)jobManagerRunner);
        Assertions.assertThat((Object)this.testInstance.get(jobId)).isEqualTo((Object)jobManagerRunner);
    }

    @Test
    void testGetOnNonExistingJobManagerRunner() {
        Assertions.assertThatThrownBy(() -> this.testInstance.get(new JobID())).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void size() {
        Assertions.assertThat((int)this.testInstance.size()).isZero();
        this.testInstance.register((JobManagerRunner)TestingJobManagerRunner.newBuilder().build());
        Assertions.assertThat((int)this.testInstance.size()).isOne();
        this.testInstance.register((JobManagerRunner)TestingJobManagerRunner.newBuilder().build());
        Assertions.assertThat((int)this.testInstance.size()).isEqualTo(2);
    }

    @Test
    void testGetRunningJobIds() {
        Assertions.assertThat((Collection)this.testInstance.getRunningJobIds()).isEmpty();
        JobID jobId0 = new JobID();
        JobID jobId1 = new JobID();
        this.testInstance.register((JobManagerRunner)TestingJobManagerRunner.newBuilder().setJobId(jobId0).build());
        this.testInstance.register((JobManagerRunner)TestingJobManagerRunner.newBuilder().setJobId(jobId1).build());
        Assertions.assertThat((Collection)this.testInstance.getRunningJobIds()).containsExactlyInAnyOrder((Object[])new JobID[]{jobId0, jobId1});
    }

    @Test
    void testGetJobManagerRunners() {
        Assertions.assertThat((Collection)this.testInstance.getJobManagerRunners()).isEmpty();
        TestingJobManagerRunner jobManagerRunner0 = TestingJobManagerRunner.newBuilder().build();
        TestingJobManagerRunner jobManagerRunner1 = TestingJobManagerRunner.newBuilder().build();
        this.testInstance.register((JobManagerRunner)jobManagerRunner0);
        this.testInstance.register((JobManagerRunner)jobManagerRunner1);
        Assertions.assertThat((Collection)this.testInstance.getJobManagerRunners()).containsExactlyInAnyOrder((Object[])new JobManagerRunner[]{jobManagerRunner0, jobManagerRunner1});
    }

    @Test
    void testSuccessfulLocalCleanup() {
        TestingJobManagerRunner jobManagerRunner = this.registerTestingJobManagerRunner();
        Assertions.assertThat((CompletableFuture)this.testInstance.localCleanupAsync(jobManagerRunner.getJobID(), Executors.directExecutor())).isCompleted();
        Assertions.assertThat((boolean)this.testInstance.isRegistered(jobManagerRunner.getJobID())).isFalse();
        Assertions.assertThat(jobManagerRunner.getTerminationFuture()).isCompleted();
    }

    @Test
    void testFailingLocalCleanup() {
        TestingJobManagerRunner jobManagerRunner = this.registerTestingJobManagerRunner();
        Assertions.assertThat((boolean)this.testInstance.isRegistered(jobManagerRunner.getJobID())).isTrue();
        Assertions.assertThat(jobManagerRunner.getTerminationFuture()).isNotDone();
        RuntimeException expectedException = new RuntimeException("Expected exception");
        jobManagerRunner.completeTerminationFutureExceptionally(expectedException);
        ((ObjectAssert)((ListAssert)((ListAssert)((FlinkCompletableFutureAssert)FlinkAssertions.assertThatFuture((CompletableFuture)this.testInstance.localCleanupAsync(jobManagerRunner.getJobID(), Executors.directExecutor())).isCompletedExceptionally()).eventuallyFailsWith(ExecutionException.class).extracting(FlinkAssertions::chainOfCauses, FlinkAssertions.STREAM_THROWABLE)).hasExactlyElementsOfTypes(new Class[]{ExecutionException.class, expectedException.getClass()})).last()).isEqualTo((Object)expectedException);
        Assertions.assertThat((boolean)this.testInstance.isRegistered(jobManagerRunner.getJobID())).isFalse();
    }

    @Test
    void testSuccessfulLocalCleanupAsync() {
        TestingJobManagerRunner jobManagerRunner = this.registerTestingJobManagerRunner();
        CompletableFuture cleanupResult = this.testInstance.localCleanupAsync(jobManagerRunner.getJobID(), Executors.directExecutor());
        Assertions.assertThat((boolean)this.testInstance.isRegistered(jobManagerRunner.getJobID())).isFalse();
        Assertions.assertThat((CompletableFuture)cleanupResult).isCompleted();
    }

    @Test
    void testFailingLocalCleanupAsync() {
        TestingJobManagerRunner jobManagerRunner = this.registerTestingJobManagerRunner();
        Assertions.assertThat((boolean)this.testInstance.isRegistered(jobManagerRunner.getJobID())).isTrue();
        Assertions.assertThat(jobManagerRunner.getTerminationFuture()).isNotDone();
        RuntimeException expectedException = new RuntimeException("Expected exception");
        jobManagerRunner.completeTerminationFutureExceptionally(expectedException);
        CompletableFuture cleanupResult = this.testInstance.localCleanupAsync(jobManagerRunner.getJobID(), Executors.directExecutor());
        Assertions.assertThat((boolean)this.testInstance.isRegistered(jobManagerRunner.getJobID())).isFalse();
        ((ObjectAssert)((ListAssert)((ListAssert)((FlinkCompletableFutureAssert)FlinkAssertions.assertThatFuture((CompletableFuture)cleanupResult).isCompletedExceptionally()).eventuallyFailsWith(ExecutionException.class).extracting(FlinkAssertions::chainOfCauses, FlinkAssertions.STREAM_THROWABLE)).hasExactlyElementsOfTypes(new Class[]{ExecutionException.class, expectedException.getClass()})).last()).isEqualTo((Object)expectedException);
    }

    @Test
    void testLocalCleanupAsyncNonBlocking() {
        TestingJobManagerRunner jobManagerRunner = TestingJobManagerRunner.newBuilder().setBlockingTermination(true).build();
        this.testInstance.register((JobManagerRunner)jobManagerRunner);
        CompletableFuture cleanupFuture = this.testInstance.localCleanupAsync(jobManagerRunner.getJobID(), (Executor)UnsupportedOperationExecutor.INSTANCE);
        Assertions.assertThat((boolean)this.testInstance.isRegistered(jobManagerRunner.getJobID())).isFalse();
        Assertions.assertThat(jobManagerRunner.getTerminationFuture()).isNotCompleted();
        Assertions.assertThat((CompletableFuture)cleanupFuture).isNotCompleted();
        jobManagerRunner.getTerminationFuture().complete(null);
        Assertions.assertThat((CompletableFuture)cleanupFuture).isCompleted();
    }

    private TestingJobManagerRunner registerTestingJobManagerRunner() {
        TestingJobManagerRunner jobManagerRunner = TestingJobManagerRunner.newBuilder().build();
        this.testInstance.register((JobManagerRunner)jobManagerRunner);
        Assertions.assertThat((boolean)this.testInstance.isRegistered(jobManagerRunner.getJobID())).isTrue();
        Assertions.assertThat(jobManagerRunner.getTerminationFuture()).isNotDone();
        return jobManagerRunner;
    }

    @Test
    void testLocalCleanupAsyncOnUnknownJobId() {
        Assertions.assertThat((CompletableFuture)this.testInstance.localCleanupAsync(new JobID(), Executors.directExecutor())).isCompleted();
    }
}

