/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorTestingUtils;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureManager;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointPlanCalculator;
import org.apache.flink.runtime.checkpoint.CheckpointPlanCalculatorContext;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DefaultCheckpointPlanCalculator;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphCheckpointPlanCalculatorContext;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;

class FailoverStrategyCheckpointCoordinatorTest {
    @RegisterExtension
    static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorExtension();
    private ManuallyTriggeredScheduledExecutor manualThreadExecutor;

    FailoverStrategyCheckpointCoordinatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.manualThreadExecutor = new ManuallyTriggeredScheduledExecutor();
    }

    @Test
    void testAbortPendingCheckpointsWithTriggerValidation() throws Exception {
        int maxConcurrentCheckpoints = ThreadLocalRandom.current().nextInt(10) + 1;
        ExecutionGraph graph = new CheckpointCoordinatorTestingUtils.CheckpointExecutionGraphBuilder().addJobVertex(new JobVertexID()).setTransitToRunning(false).build((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor());
        CheckpointCoordinatorConfiguration checkpointCoordinatorConfiguration = new CheckpointCoordinatorConfiguration(Integer.MAX_VALUE, Integer.MAX_VALUE, 0L, maxConcurrentCheckpoints, CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION, true, false, 0, 0L);
        CheckpointCoordinator checkpointCoordinator = new CheckpointCoordinator(graph.getJobID(), checkpointCoordinatorConfiguration, Collections.emptyList(), (CheckpointIDCounter)new StandaloneCheckpointIDCounter(), (CompletedCheckpointStore)new StandaloneCompletedCheckpointStore(1), (CheckpointStorage)new MemoryStateBackend(), Executors.directExecutor(), new CheckpointsCleaner(), (ScheduledExecutor)this.manualThreadExecutor, (CheckpointFailureManager)Mockito.mock(CheckpointFailureManager.class), (CheckpointPlanCalculator)new DefaultCheckpointPlanCalculator(graph.getJobID(), (CheckpointPlanCalculatorContext)new ExecutionGraphCheckpointPlanCalculatorContext(graph), graph.getVerticesTopologically(), false), (CheckpointStatsTracker)Mockito.mock(CheckpointStatsTracker.class));
        graph.transitionToRunning();
        graph.getAllExecutionVertices().forEach(task -> task.getCurrentExecutionAttempt().transitionState(ExecutionState.RUNNING));
        checkpointCoordinator.startCheckpointScheduler();
        Assertions.assertThat((boolean)checkpointCoordinator.isCurrentPeriodicTriggerAvailable()).isTrue();
        this.manualThreadExecutor.triggerNonPeriodicScheduledTasks(CheckpointCoordinator.ScheduledTrigger.class);
        this.manualThreadExecutor.triggerAll();
        Assertions.assertThat((int)checkpointCoordinator.getNumberOfPendingCheckpoints()).isOne();
        for (int i = 1; i < maxConcurrentCheckpoints; ++i) {
            checkpointCoordinator.triggerCheckpoint(false);
            this.manualThreadExecutor.triggerAll();
            Assertions.assertThat((int)checkpointCoordinator.getNumberOfPendingCheckpoints()).isEqualTo(i + 1);
            Assertions.assertThat((boolean)checkpointCoordinator.isCurrentPeriodicTriggerAvailable()).isTrue();
        }
        checkpointCoordinator.triggerCheckpoint(false);
        this.manualThreadExecutor.triggerAll();
        Assertions.assertThat((int)checkpointCoordinator.getNumberOfPendingCheckpoints()).isEqualTo(maxConcurrentCheckpoints);
        checkpointCoordinator.abortPendingCheckpoints(new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION));
        Assertions.assertThat((boolean)checkpointCoordinator.isCurrentPeriodicTriggerAvailable()).isTrue();
        Assertions.assertThat((int)checkpointCoordinator.getNumberOfPendingCheckpoints()).isZero();
    }
}

