/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.TestingBlobUtils;
import org.apache.flink.runtime.blob.TransientBlobCache;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class TransientBlobCacheTest {
    TransientBlobCacheTest() {
    }

    @Test
    void transientBlobCacheCanServeFilesFromPrepopulatedStorageDirectory(@TempDir Path storageDirectory) throws IOException {
        JobID jobId = new JobID();
        TransientBlobKey blobKey = TestingBlobUtils.writeTransientBlob(storageDirectory, jobId, new byte[]{1, 2, 3, 4});
        try (TransientBlobCache transientBlobCache = new TransientBlobCache(new Configuration(), storageDirectory.toFile(), null);){
            transientBlobCache.getFile(jobId, blobKey);
        }
    }

    @Test
    void transientBlobCacheChecksForCorruptedBlobsAtStart(@TempDir Path storageDirectory) throws IOException {
        JobID jobId = new JobID();
        TransientBlobKey blobKey = TestingBlobUtils.writeTransientBlob(storageDirectory, jobId, new byte[]{1, 2, 3, 4});
        FileUtils.writeByteArrayToFile((File)new File(BlobUtils.getStorageLocationPath((String)storageDirectory.toString(), (JobID)jobId, (BlobKey)blobKey)), (byte[])new byte[]{4, 3, 2, 1});
        try (TransientBlobCache transientBlobCache = new TransientBlobCache(new Configuration(), storageDirectory.toFile(), null);){
            Assertions.assertThatThrownBy(() -> transientBlobCache.getFile(jobId, blobKey)).isInstanceOf(IOException.class);
        }
    }

    @Test
    void transientBlobCacheTimesOutRecoveredBlobs(@TempDir Path storageDirectory) throws Exception {
        JobID jobId = new JobID();
        TransientBlobKey transientBlobKey = TestingBlobUtils.writeTransientBlob(storageDirectory, jobId, new byte[]{1, 2, 3, 4});
        File blobFile = BlobUtils.getStorageLocation((File)storageDirectory.toFile(), (JobID)jobId, (BlobKey)transientBlobKey);
        Configuration configuration = new Configuration();
        long cleanupInterval = 1L;
        configuration.set(BlobServerOptions.CLEANUP_INTERVAL, (Object)1L);
        try (TransientBlobCache transientBlobCache = new TransientBlobCache(configuration, storageDirectory.toFile(), null);){
            CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> !blobFile.exists()));
        }
    }
}

