/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.resettable;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.SimpleCollectingOutputView;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.ListMemorySegmentSource;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.util.MemoryBlockIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBlockResettableIterator<T>
implements MemoryBlockIterator {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractBlockResettableIterator.class);
    protected final RandomAccessInputView readView;
    protected final SimpleCollectingOutputView collectingView;
    protected final TypeSerializer<T> serializer;
    protected int numRecordsInBuffer;
    protected int numRecordsReturned;
    protected final ArrayList<MemorySegment> emptySegments;
    protected final ArrayList<MemorySegment> fullSegments;
    private final MemoryManager memoryManager;
    protected volatile boolean closed;

    protected AbstractBlockResettableIterator(TypeSerializer<T> serializer, MemoryManager memoryManager, int numPages, AbstractInvokable ownerTask) throws MemoryAllocationException {
        if (numPages < 1) {
            throw new IllegalArgumentException("Block Resettable iterator requires at leat one page of memory");
        }
        this.memoryManager = memoryManager;
        this.serializer = serializer;
        this.emptySegments = new ArrayList(numPages);
        this.fullSegments = new ArrayList(numPages);
        memoryManager.allocatePages(ownerTask, this.emptySegments, numPages);
        this.collectingView = new SimpleCollectingOutputView(this.fullSegments, new ListMemorySegmentSource(this.emptySegments), memoryManager.getPageSize());
        this.readView = new RandomAccessInputView(this.fullSegments, memoryManager.getPageSize());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Iterator initialized using " + numPages + " memory buffers.");
        }
    }

    public void open() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Block Resettable Iterator opened.");
        }
    }

    public void reset() {
        if (this.closed) {
            throw new IllegalStateException("Iterator was closed.");
        }
        this.readView.setReadPosition(0L);
        this.numRecordsReturned = 0;
    }

    @Override
    public boolean nextBlock() throws IOException {
        this.numRecordsInBuffer = 0;
        for (int i = this.fullSegments.size() - 1; i >= 0; --i) {
            this.emptySegments.add(this.fullSegments.remove(i));
        }
        this.collectingView.reset();
        this.readView.setReadPosition(0L);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AbstractBlockResettableIterator abstractBlockResettableIterator = this;
        synchronized (abstractBlockResettableIterator) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.numRecordsInBuffer = 0;
        this.numRecordsReturned = 0;
        for (int i = this.fullSegments.size() - 1; i >= 0; --i) {
            this.emptySegments.add(this.fullSegments.remove(i));
        }
        this.memoryManager.release(this.emptySegments);
        this.emptySegments.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Block Resettable Iterator closed.");
        }
    }

    protected boolean writeNextRecord(T record) throws IOException {
        try {
            this.serializer.serialize(record, (DataOutputView)this.collectingView);
            ++this.numRecordsInBuffer;
            return true;
        }
        catch (EOFException eofex) {
            return false;
        }
    }

    protected T getNextRecord(T reuse) throws IOException {
        if (this.numRecordsReturned < this.numRecordsInBuffer) {
            ++this.numRecordsReturned;
            return (T)this.serializer.deserialize(reuse, (DataInputView)this.readView);
        }
        return null;
    }

    protected T getNextRecord() throws IOException {
        if (this.numRecordsReturned < this.numRecordsInBuffer) {
            ++this.numRecordsReturned;
            return (T)this.serializer.deserialize((DataInputView)this.readView);
        }
        return null;
    }
}

