/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;

public class VertexEndOfDataListener {
    private final ExecutionGraph executionGraph;
    private final Map<JobVertexID, BitSet> tasksReachedEndOfData;

    public VertexEndOfDataListener(ExecutionGraph executionGraph) {
        this.executionGraph = executionGraph;
        this.tasksReachedEndOfData = new HashMap<JobVertexID, BitSet>();
        for (ExecutionJobVertex vertex : executionGraph.getAllVertices().values()) {
            this.tasksReachedEndOfData.put(vertex.getJobVertexId(), new BitSet());
        }
    }

    public void recordTaskEndOfData(ExecutionAttemptID executionAttemptID) {
        BitSet subtaskStatus = this.tasksReachedEndOfData.get(executionAttemptID.getJobVertexId());
        subtaskStatus.set(executionAttemptID.getSubtaskIndex());
    }

    public boolean areAllTasksEndOfData() {
        Iterator<Map.Entry<JobVertexID, BitSet>> iterator = this.tasksReachedEndOfData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<JobVertexID, BitSet> entry = iterator.next();
            JobVertexID vertex = entry.getKey();
            BitSet status = entry.getValue();
            if (status.cardinality() != this.executionGraph.getJobVertex(vertex).getParallelism()) {
                return false;
            }
            iterator.remove();
        }
        return true;
    }

    public void restoreVertices(Set<ExecutionVertexID> executionVertices) {
        for (ExecutionVertexID executionVertex : executionVertices) {
            JobVertexID jobVertexId = executionVertex.getJobVertexId();
            this.tasksReachedEndOfData.putIfAbsent(jobVertexId, new BitSet());
            this.tasksReachedEndOfData.get(jobVertexId).set(executionVertex.getSubtaskIndex(), false);
        }
    }
}

