/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.memory;

import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyPayload;
import org.apache.flink.util.Preconditions;

class MemoryTierSubpartitionProducerAgent {
    private final int subpartitionId;
    @Nullable
    private volatile NettyConnectionWriter nettyConnectionWriter;
    private int finishedBufferIndex;

    MemoryTierSubpartitionProducerAgent(int subpartitionId) {
        this.subpartitionId = subpartitionId;
    }

    void connectionEstablished(NettyConnectionWriter nettyConnectionWriter) {
        this.nettyConnectionWriter = nettyConnectionWriter;
    }

    void addFinishedBuffer(Buffer buffer) {
        NettyPayload toAddBuffer = NettyPayload.newBuffer(buffer, this.finishedBufferIndex, this.subpartitionId);
        this.addFinishedBuffer(toAddBuffer);
    }

    void updateSegmentId(int segmentId) {
        NettyPayload segmentNettyPayload = NettyPayload.newSegment(segmentId);
        this.addFinishedBuffer(segmentNettyPayload);
    }

    int numQueuedBuffers() {
        return this.nettyConnectionWriter == null ? 0 : ((NettyConnectionWriter)Preconditions.checkNotNull((Object)this.nettyConnectionWriter)).numQueuedBufferPayloads();
    }

    void release() {
        if (this.nettyConnectionWriter != null) {
            ((NettyConnectionWriter)Preconditions.checkNotNull((Object)this.nettyConnectionWriter)).close(null);
        }
    }

    private void addFinishedBuffer(NettyPayload nettyPayload) {
        ++this.finishedBufferIndex;
        ((NettyConnectionWriter)Preconditions.checkNotNull((Object)this.nettyConnectionWriter)).writeNettyPayload(nettyPayload);
        if (((NettyConnectionWriter)Preconditions.checkNotNull((Object)this.nettyConnectionWriter)).numQueuedPayloads() <= 1 || ((NettyConnectionWriter)Preconditions.checkNotNull((Object)this.nettyConnectionWriter)).numQueuedBufferPayloads() <= 1) {
            ((NettyConnectionWriter)Preconditions.checkNotNull((Object)this.nettyConnectionWriter)).notifyAvailable();
        }
    }
}

