/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.api.serialization.NonSpanningWrapper;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningWrapper;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.CloseableIterator;

public class SpillingAdaptiveSpanningRecordDeserializer<T extends IOReadableWritable>
implements RecordDeserializer<T> {
    public static final int DEFAULT_THRESHOLD_FOR_SPILLING = 0x500000;
    public static final int DEFAULT_FILE_BUFFER_SIZE = 0x200000;
    private static final int MIN_THRESHOLD_FOR_SPILLING = 102400;
    private static final int MIN_FILE_BUFFER_SIZE = 51200;
    static final int LENGTH_BYTES = 4;
    private final NonSpanningWrapper nonSpanningWrapper = new NonSpanningWrapper();
    private final SpanningWrapper spanningWrapper;
    @Nullable
    private Buffer currentBuffer;

    public SpillingAdaptiveSpanningRecordDeserializer(String[] tmpDirectories) {
        this(tmpDirectories, 0x500000, 0x200000);
    }

    public SpillingAdaptiveSpanningRecordDeserializer(String[] tmpDirectories, int thresholdForSpilling, int fileBufferSize) {
        this.spanningWrapper = new SpanningWrapper(tmpDirectories, Math.max(thresholdForSpilling, 102400), Math.max(fileBufferSize, 51200));
    }

    @Override
    public void setNextBuffer(Buffer buffer) throws IOException {
        this.currentBuffer = buffer;
        int offset = buffer.getMemorySegmentOffset();
        MemorySegment segment = buffer.getMemorySegment();
        int numBytes = buffer.getSize();
        if (this.spanningWrapper.getNumGatheredBytes() > 0) {
            this.spanningWrapper.addNextChunkFromMemorySegment(segment, offset, numBytes);
        } else {
            this.nonSpanningWrapper.initializeFromMemorySegment(segment, offset, numBytes + offset);
        }
    }

    @Override
    public CloseableIterator<Buffer> getUnconsumedBuffer() throws IOException {
        return this.nonSpanningWrapper.hasRemaining() ? this.nonSpanningWrapper.getUnconsumedSegment() : this.spanningWrapper.getUnconsumedSegment();
    }

    @Override
    public RecordDeserializer.DeserializationResult getNextRecord(T target) throws IOException {
        RecordDeserializer.DeserializationResult result = this.readNextRecord(target);
        if (result.isBufferConsumed()) {
            this.currentBuffer.recycleBuffer();
            this.currentBuffer = null;
        }
        return result;
    }

    private RecordDeserializer.DeserializationResult readNextRecord(T target) throws IOException {
        if (this.nonSpanningWrapper.hasCompleteLength()) {
            return this.readNonSpanningRecord(target);
        }
        if (this.nonSpanningWrapper.hasRemaining()) {
            this.nonSpanningWrapper.transferTo(this.spanningWrapper.lengthBuffer);
            return RecordDeserializer.DeserializationResult.PARTIAL_RECORD;
        }
        if (this.spanningWrapper.hasFullRecord()) {
            target.read(this.spanningWrapper.getInputView());
            this.spanningWrapper.transferLeftOverTo(this.nonSpanningWrapper);
            return this.nonSpanningWrapper.hasRemaining() ? RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER : RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER;
        }
        return RecordDeserializer.DeserializationResult.PARTIAL_RECORD;
    }

    private RecordDeserializer.DeserializationResult readNonSpanningRecord(T target) throws IOException {
        int recordLen = this.nonSpanningWrapper.readInt();
        if (this.nonSpanningWrapper.canReadRecord(recordLen)) {
            return this.nonSpanningWrapper.readInto((IOReadableWritable)target);
        }
        this.spanningWrapper.transferFrom(this.nonSpanningWrapper, recordLen);
        return RecordDeserializer.DeserializationResult.PARTIAL_RECORD;
    }

    @Override
    public void clear() {
        if (this.currentBuffer != null && !this.currentBuffer.isRecycled()) {
            this.currentBuffer.recycleBuffer();
            this.currentBuffer = null;
        }
        this.nonSpanningWrapper.clear();
        this.spanningWrapper.clear();
    }
}

