/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.runtime.state.ttl.TtlStateTestContextBase;
import org.apache.flink.runtime.state.ttl.TtlValueState;

class TtlValueStateTestContext
extends TtlStateTestContextBase<TtlValueState<?, String, String>, String, String> {
    private static final String TEST_VAL1 = "test value1";
    private static final String TEST_VAL2 = "test value2";
    private static final String TEST_VAL3 = "test value3";

    TtlValueStateTestContext() {
    }

    @Override
    void initTestValues() {
        this.updateEmpty = TEST_VAL1;
        this.updateUnexpired = TEST_VAL2;
        this.updateExpired = TEST_VAL3;
        this.getUpdateEmpty = TEST_VAL1;
        this.getUnexpired = TEST_VAL2;
        this.getUpdateExpired = TEST_VAL3;
    }

    @Override
    public <US extends State, SV> StateDescriptor<US, SV> createStateDescriptor() {
        return new ValueStateDescriptor(this.getName(), (TypeSerializer)StringSerializer.INSTANCE);
    }

    @Override
    public void update(String value) throws Exception {
        ((TtlValueState)this.ttlState).update((Object)value);
    }

    @Override
    public String get() throws Exception {
        return (String)((TtlValueState)this.ttlState).value();
    }

    @Override
    public Object getOriginal() throws Exception {
        return ((InternalValueState)((TtlValueState)this.ttlState).original).value();
    }
}

