/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.junit.Assert;
import org.junit.Test;

public class MemoryCheckpointOutputStreamTest {
    @Test
    public void testOversizedState() throws Exception {
        HashMap<String, Integer> state = new HashMap<String, Integer>();
        state.put("hey there", 2);
        state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
        MemCheckpointStreamFactory.MemoryCheckpointOutputStream outStream = new MemCheckpointStreamFactory.MemoryCheckpointOutputStream(10);
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)outStream);
        oos.writeObject(state);
        oos.flush();
        try {
            outStream.closeAndGetHandle();
            Assert.fail((String)"this should cause an exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testStateStream() throws Exception {
        HashMap<String, Integer> state = new HashMap<String, Integer>();
        state.put("hey there", 2);
        state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
        MemCheckpointStreamFactory.MemoryCheckpointOutputStream outStream = new MemCheckpointStreamFactory.MemoryCheckpointOutputStream(0x500000);
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)outStream);
        oos.writeObject(state);
        oos.flush();
        StreamStateHandle handle = outStream.closeAndGetHandle();
        Assert.assertNotNull((Object)handle);
        try (ObjectInputStream ois = new ObjectInputStream((InputStream)handle.openInputStream());){
            Assert.assertEquals(state, (Object)ois.readObject());
            Assert.assertTrue((ois.available() <= 0 ? 1 : 0) != 0);
        }
    }
}

