/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.scheduler.DefaultVertexParallelismInfo;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class DefaultVertexParallelismInfoTest
extends TestLogger {
    private static final Function<Integer, Optional<String>> ALWAYS_VALID = max -> Optional.empty();

    @Test
    public void parallelismInvalid() {
        CommonTestUtils.assertThrows((String)"parallelism is not in valid bounds", IllegalArgumentException.class, () -> new DefaultVertexParallelismInfo(-2, 1, ALWAYS_VALID));
    }

    @Test
    public void parallelismValid() {
        new DefaultVertexParallelismInfo(10, 1, ALWAYS_VALID);
        new DefaultVertexParallelismInfo(-1, 1, ALWAYS_VALID);
    }

    @Test
    public void maxParallelismInvalid() {
        CommonTestUtils.assertThrows((String)"max parallelism is not in valid bounds", IllegalArgumentException.class, () -> new DefaultVertexParallelismInfo(1, -1, ALWAYS_VALID));
    }

    @Test
    public void testSetParallelism() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(-1, 10, ALWAYS_VALID);
        CommonTestUtils.assertThrows((String)"parallelism is not in valid bounds", IllegalArgumentException.class, () -> {
            info.setParallelism(-1);
            return null;
        });
        CommonTestUtils.assertThrows((String)"Vertex's parallelism should be smaller than or equal to vertex's max parallelism.", IllegalArgumentException.class, () -> {
            info.setParallelism(11);
            return null;
        });
        info.setParallelism(5);
        CommonTestUtils.assertThrows((String)"Vertex's parallelism can be set only if the vertex's parallelism was not decided yet.", IllegalStateException.class, () -> {
            info.setParallelism(5);
            return null;
        });
    }

    @Test
    public void setAutoMax() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, Integer.MAX_VALUE, ALWAYS_VALID);
        Assert.assertEquals((long)32768L, (long)info.getMaxParallelism());
    }

    @Test
    public void canRescaleMaxOutOfBounds() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        CommonTestUtils.assertThrows((String)"not in valid bounds", IllegalArgumentException.class, () -> info.canRescaleMaxParallelism(-4));
    }

    @Test
    public void canRescaleMaxAuto() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        Assert.assertTrue((boolean)info.canRescaleMaxParallelism(Integer.MAX_VALUE));
    }

    @Test
    public void canRescaleMax() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        Assert.assertTrue((boolean)info.canRescaleMaxParallelism(3));
    }

    @Test
    public void canRescaleMaxDefault() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        Assert.assertFalse((boolean)info.canRescaleMaxParallelism(-1));
    }

    @Test
    public void setMaxOutOfBounds() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        CommonTestUtils.assertThrows((String)"not in valid bounds", IllegalArgumentException.class, () -> {
            info.setMaxParallelism(-4);
            return null;
        });
    }

    @Test
    public void setMaxInvalid() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, max -> Optional.of("not valid"));
        CommonTestUtils.assertThrows((String)"not valid", IllegalArgumentException.class, () -> {
            info.setMaxParallelism(4);
            return null;
        });
    }

    @Test
    public void setMaxValid() {
        DefaultVertexParallelismInfo info = new DefaultVertexParallelismInfo(1, 1, ALWAYS_VALID);
        info.setMaxParallelism(40);
        Assert.assertEquals((long)40L, (long)info.getMaxParallelism());
    }
}

