/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class RestHandlerConfigurationTest
extends TestLogger {
    @Test
    public void testWebSubmitFeatureFlagEnabled() {
        RestHandlerConfigurationTest.testWebSubmitFeatureFlag(true);
    }

    @Test
    public void testWebSubmitFeatureFlagDisabled() {
        RestHandlerConfigurationTest.testWebSubmitFeatureFlag(false);
    }

    @Test
    public void testWebCancelFeatureFlagEnabled() {
        RestHandlerConfigurationTest.testWebCancelFeatureFlag(true);
    }

    @Test
    public void testWebCancelFeatureFlagDisabled() {
        RestHandlerConfigurationTest.testWebCancelFeatureFlag(false);
    }

    private static void testWebSubmitFeatureFlag(boolean webSubmitEnabled) {
        Configuration config = new Configuration();
        config.setBoolean(WebOptions.SUBMIT_ENABLE, webSubmitEnabled);
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)config);
        Assert.assertEquals((Object)webSubmitEnabled, (Object)restHandlerConfiguration.isWebSubmitEnabled());
    }

    private static void testWebCancelFeatureFlag(boolean webCancelEnabled) {
        Configuration config = new Configuration();
        config.setBoolean(WebOptions.CANCEL_ENABLE, webCancelEnabled);
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)config);
        Assert.assertEquals((Object)webCancelEnabled, (Object)restHandlerConfiguration.isWebCancelEnabled());
    }
}

