/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceTracker;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Assert;
import org.junit.Test;

public class DefaultResourceTrackerTest
extends TestLogger {
    private static final JobID JOB_ID_1 = JobID.generate();
    private static final JobID JOB_ID_2 = JobID.generate();

    @Test
    public void testInitialBehavior() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        tracker.notifyLostResource(JobID.generate(), ResourceProfile.ANY);
    }

    @Test
    public void testClearDoesNotThrowException() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        tracker.clear();
    }

    @Test
    public void testGetRequiredResources() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        ResourceRequirement requirement1 = ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1);
        ResourceRequirement requirement2 = ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)2);
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.singletonList(requirement1));
        tracker.notifyResourceRequirements(JOB_ID_2, Collections.singletonList(requirement2));
        Map requiredResources = tracker.getMissingResources();
        Assert.assertThat((Object)requiredResources, (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)JOB_ID_1), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{requirement1})));
        Assert.assertThat((Object)requiredResources, (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)JOB_ID_2), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{requirement2})));
    }

    @Test
    public void testGetAcquiredResources() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        ResourceRequirement requirement1 = ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1);
        ResourceRequirement requirement2 = ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)2);
        tracker.notifyAcquiredResource(JOB_ID_1, requirement1.getResourceProfile());
        for (int x = 0; x < requirement2.getNumberOfRequiredSlots(); ++x) {
            tracker.notifyAcquiredResource(JOB_ID_2, requirement2.getResourceProfile());
        }
        Assert.assertThat((Object)tracker.getAcquiredResources(JOB_ID_1), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{requirement1}));
        Assert.assertThat((Object)tracker.getAcquiredResources(JOB_ID_2), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{requirement2}));
        tracker.notifyLostResource(JOB_ID_1, requirement1.getResourceProfile());
        Assert.assertThat((Object)tracker.getAcquiredResources(JOB_ID_1), (Matcher)Matchers.empty());
    }

    @Test
    public void testTrackerRemovedOnRequirementReset() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.singletonList(ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)));
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.emptyList());
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testTrackerRemovedOnResourceLoss() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        tracker.notifyAcquiredResource(JOB_ID_1, ResourceProfile.ANY);
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        tracker.notifyLostResource(JOB_ID_1, ResourceProfile.ANY);
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testTrackerRetainedOnResourceLossIfRequirementExists() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        tracker.notifyAcquiredResource(JOB_ID_1, ResourceProfile.ANY);
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.singletonList(ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)));
        tracker.notifyLostResource(JOB_ID_1, ResourceProfile.ANY);
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.emptyList());
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testTrackerRetainedOnRequirementResetIfResourceExists() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        tracker.notifyAcquiredResource(JOB_ID_1, ResourceProfile.ANY);
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.singletonList(ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)));
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.emptyList());
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        tracker.notifyLostResource(JOB_ID_1, ResourceProfile.ANY);
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }
}

