/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.util.TestCounter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferIndexAndChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.HsOutputMetrics;

public class HybridShuffleTestUtils {
    public static final int MEMORY_SEGMENT_SIZE = 128;

    public static List<BufferIndexAndChannel> createBufferIndexAndChannelsList(int subpartitionId, int ... bufferIndexes) {
        ArrayList<BufferIndexAndChannel> bufferIndexAndChannels = new ArrayList<BufferIndexAndChannel>();
        for (int bufferIndex : bufferIndexes) {
            MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)128);
            NetworkBuffer buffer = new NetworkBuffer(segment, ignore -> {});
            bufferIndexAndChannels.add(new BufferIndexAndChannel(bufferIndex, subpartitionId));
        }
        return bufferIndexAndChannels;
    }

    public static Deque<BufferIndexAndChannel> createBufferIndexAndChannelsDeque(int subpartitionId, int ... bufferIndexes) {
        ArrayDeque<BufferIndexAndChannel> bufferIndexAndChannels = new ArrayDeque<BufferIndexAndChannel>();
        for (int bufferIndex : bufferIndexes) {
            bufferIndexAndChannels.add(new BufferIndexAndChannel(bufferIndex, subpartitionId));
        }
        return bufferIndexAndChannels;
    }

    public static Buffer createBuffer(int bufferSize, boolean isEvent) {
        return new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize), FreeingBufferRecycler.INSTANCE, isEvent ? Buffer.DataType.EVENT_BUFFER : Buffer.DataType.DATA_BUFFER, bufferSize);
    }

    public static BufferBuilder createBufferBuilder(int bufferSize) {
        return new BufferBuilder(MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize), FreeingBufferRecycler.INSTANCE);
    }

    public static HsOutputMetrics createTestingOutputMetrics() {
        return new HsOutputMetrics((Counter)new TestCounter(), (Counter)new TestCounter());
    }
}

