/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.NoOpBufferAvailablityListener;
import org.apache.flink.runtime.io.network.partition.PartitionTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.util.TestLogger;
import org.junit.Test;

public class ResultPartitionManagerTest
extends TestLogger {
    @Test
    public void testThrowPartitionNotFoundException() throws Exception {
        ResultPartitionManager partitionManager = new ResultPartitionManager();
        ResultPartition partition = PartitionTestUtils.createPartition();
        PartitionTestUtils.verifyCreateSubpartitionViewThrowsException((ResultPartitionProvider)partitionManager, partition.getPartitionId());
    }

    @Test
    public void testCreateViewForRegisteredPartition() throws Exception {
        ResultPartitionManager partitionManager = new ResultPartitionManager();
        ResultPartition partition = PartitionTestUtils.createPartition();
        partitionManager.registerResultPartition(partition);
        partitionManager.createSubpartitionView(partition.getPartitionId(), 0, (BufferAvailabilityListener)new NoOpBufferAvailablityListener());
    }

    @Test
    public void testCreateViewForReleasedPartition() throws Exception {
        ResultPartitionManager partitionManager = new ResultPartitionManager();
        ResultPartition partition = PartitionTestUtils.createPartition();
        partitionManager.registerResultPartition(partition);
        partitionManager.releasePartition(partition.getPartitionId(), null);
        PartitionTestUtils.verifyCreateSubpartitionViewThrowsException((ResultPartitionProvider)partitionManager, partition.getPartitionId());
    }
}

