/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.partition.DataSetMetaInfo;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerImpl;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.TaskExecutorClusterPartitionReleaser;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.taskexecutor.partition.ClusterPartitionReport;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.junit.Test;

public class ResourceManagerPartitionTrackerImplTest
extends TestLogger {
    private static final ClusterPartitionReport EMPTY_PARTITION_REPORT = new ClusterPartitionReport(Collections.emptySet());
    private static final ResourceID TASK_EXECUTOR_ID_1 = ResourceID.generate();
    private static final ResourceID TASK_EXECUTOR_ID_2 = ResourceID.generate();
    private static final IntermediateDataSetID DATA_SET_ID = new IntermediateDataSetID();
    private static final ResultPartitionID PARTITION_ID_1 = new ResultPartitionID();
    private static final ResultPartitionID PARTITION_ID_2 = new ResultPartitionID();

    @Test
    public void testProcessEmptyClusterPartitionReport() {
        TestClusterPartitionReleaser partitionReleaser = new TestClusterPartitionReleaser();
        ResourceManagerPartitionTrackerImpl tracker = new ResourceManagerPartitionTrackerImpl((TaskExecutorClusterPartitionReleaser)partitionReleaser);
        ResourceManagerPartitionTrackerImplTest.reportEmpty((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1);
        MatcherAssert.assertThat(partitionReleaser.releaseCalls, (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)tracker.areAllMapsEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testReportProcessingWithPartitionLossOnSameTaskExecutor() {
        TestClusterPartitionReleaser partitionReleaser = new TestClusterPartitionReleaser();
        ResourceManagerPartitionTrackerImpl tracker = new ResourceManagerPartitionTrackerImpl((TaskExecutorClusterPartitionReleaser)partitionReleaser);
        ResourceManagerPartitionTrackerImplTest.report((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1, DATA_SET_ID, 2, PARTITION_ID_1, PARTITION_ID_2);
        ResourceManagerPartitionTrackerImplTest.report((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1, DATA_SET_ID, 2, PARTITION_ID_2);
        MatcherAssert.assertThat(partitionReleaser.releaseCalls, (Matcher)Matchers.contains((Object[])new Tuple2[]{Tuple2.of((Object)TASK_EXECUTOR_ID_1, Collections.singleton(DATA_SET_ID))}));
    }

    @Test
    public void testReportProcessingWithPartitionLossOnOtherTaskExecutor() {
        TestClusterPartitionReleaser partitionReleaser = new TestClusterPartitionReleaser();
        ResourceManagerPartitionTrackerImpl tracker = new ResourceManagerPartitionTrackerImpl((TaskExecutorClusterPartitionReleaser)partitionReleaser);
        ResourceManagerPartitionTrackerImplTest.report((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1, DATA_SET_ID, 2, PARTITION_ID_1);
        ResourceManagerPartitionTrackerImplTest.report((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_2, DATA_SET_ID, 2, PARTITION_ID_2);
        ResourceManagerPartitionTrackerImplTest.reportEmpty((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1);
        MatcherAssert.assertThat(partitionReleaser.releaseCalls, (Matcher)Matchers.contains((Object[])new Tuple2[]{Tuple2.of((Object)TASK_EXECUTOR_ID_2, Collections.singleton(DATA_SET_ID))}));
    }

    @Test
    public void testListDataSetsBasics() {
        ResourceManagerPartitionTrackerImpl tracker = new ResourceManagerPartitionTrackerImpl((TaskExecutorClusterPartitionReleaser)new TestClusterPartitionReleaser());
        MatcherAssert.assertThat((Object)tracker.listDataSets().size(), (Matcher)Is.is((Object)0));
        ResourceManagerPartitionTrackerImplTest.report((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1, DATA_SET_ID, 2, PARTITION_ID_1);
        ResourceManagerPartitionTrackerImplTest.checkListedDataSets((ResourceManagerPartitionTracker)tracker, 1, 2);
        ResourceManagerPartitionTrackerImplTest.report((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_2, DATA_SET_ID, 2, PARTITION_ID_2);
        ResourceManagerPartitionTrackerImplTest.checkListedDataSets((ResourceManagerPartitionTracker)tracker, 2, 2);
        ResourceManagerPartitionTrackerImplTest.reportEmpty((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1);
        ResourceManagerPartitionTrackerImplTest.checkListedDataSets((ResourceManagerPartitionTracker)tracker, 1, 2);
        ResourceManagerPartitionTrackerImplTest.reportEmpty((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_2);
        MatcherAssert.assertThat((Object)tracker.listDataSets().size(), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)tracker.areAllMapsEmpty(), (Matcher)Is.is((Object)true));
    }

    private static void checkListedDataSets(ResourceManagerPartitionTracker tracker, int expectedRegistered, int expectedTotal) {
        Map listing = tracker.listDataSets();
        MatcherAssert.assertThat((Object)listing, (Matcher)Matchers.hasKey((Object)DATA_SET_ID));
        DataSetMetaInfo metaInfo = (DataSetMetaInfo)listing.get(DATA_SET_ID);
        MatcherAssert.assertThat((Object)metaInfo.getNumRegisteredPartitions().orElse(-1), (Matcher)Is.is((Object)expectedRegistered));
        MatcherAssert.assertThat((Object)metaInfo.getNumTotalPartitions(), (Matcher)Is.is((Object)expectedTotal));
    }

    @Test
    public void testReleasePartition() {
        TestClusterPartitionReleaser partitionReleaser = new TestClusterPartitionReleaser();
        ResourceManagerPartitionTrackerImpl tracker = new ResourceManagerPartitionTrackerImpl((TaskExecutorClusterPartitionReleaser)partitionReleaser);
        ResourceManagerPartitionTrackerImplTest.report((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1, DATA_SET_ID, 2, PARTITION_ID_1);
        ResourceManagerPartitionTrackerImplTest.report((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_2, DATA_SET_ID, 2, PARTITION_ID_2);
        CompletableFuture partitionReleaseFuture = tracker.releaseClusterPartitions(DATA_SET_ID);
        MatcherAssert.assertThat(partitionReleaser.releaseCalls, (Matcher)Matchers.containsInAnyOrder((Object[])new Tuple2[]{Tuple2.of((Object)TASK_EXECUTOR_ID_1, Collections.singleton(DATA_SET_ID)), Tuple2.of((Object)TASK_EXECUTOR_ID_2, Collections.singleton(DATA_SET_ID))}));
        MatcherAssert.assertThat(tracker.listDataSets().keySet(), (Matcher)Matchers.contains((Object[])new IntermediateDataSetID[]{DATA_SET_ID}));
        ResourceManagerPartitionTrackerImplTest.reportEmpty((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1, TASK_EXECUTOR_ID_2);
        MatcherAssert.assertThat((Object)partitionReleaseFuture.isDone(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)tracker.areAllMapsEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testShutdownProcessing() {
        TestClusterPartitionReleaser partitionReleaser = new TestClusterPartitionReleaser();
        ResourceManagerPartitionTrackerImpl tracker = new ResourceManagerPartitionTrackerImpl((TaskExecutorClusterPartitionReleaser)partitionReleaser);
        tracker.processTaskExecutorShutdown(TASK_EXECUTOR_ID_1);
        MatcherAssert.assertThat(partitionReleaser.releaseCalls, (Matcher)IsEmptyCollection.empty());
        ResourceManagerPartitionTrackerImplTest.report((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1, DATA_SET_ID, 3, PARTITION_ID_1, PARTITION_ID_2);
        ResourceManagerPartitionTrackerImplTest.report((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_2, DATA_SET_ID, 3, new ResultPartitionID());
        tracker.processTaskExecutorShutdown(TASK_EXECUTOR_ID_1);
        MatcherAssert.assertThat(partitionReleaser.releaseCalls, (Matcher)Matchers.contains((Object[])new Tuple2[]{Tuple2.of((Object)TASK_EXECUTOR_ID_2, Collections.singleton(DATA_SET_ID))}));
        MatcherAssert.assertThat((Object)tracker.areAllMapsEmpty(), (Matcher)Is.is((Object)false));
        tracker.processTaskExecutorShutdown(TASK_EXECUTOR_ID_2);
        MatcherAssert.assertThat((Object)tracker.areAllMapsEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testGetClusterPartitionShuffleDescriptors() {
        ResourceManagerPartitionTrackerImpl tracker = new ResourceManagerPartitionTrackerImpl((TaskExecutorClusterPartitionReleaser)new TestClusterPartitionReleaser());
        MatcherAssert.assertThat((Object)tracker.listDataSets().size(), (Matcher)Is.is((Object)0));
        ArrayList<ResultPartitionID> resultPartitionIDS = new ArrayList<ResultPartitionID>();
        for (int i = 0; i < 100; ++i) {
            resultPartitionIDS.add(new ResultPartitionID(new IntermediateResultPartitionID(DATA_SET_ID, i), ExecutionAttemptID.randomId()));
        }
        for (ResultPartitionID resultPartitionID : resultPartitionIDS) {
            ResourceManagerPartitionTrackerImplTest.report((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1, DATA_SET_ID, 100, resultPartitionID);
        }
        List shuffleDescriptors = tracker.getClusterPartitionShuffleDescriptors(DATA_SET_ID);
        MatcherAssert.assertThat((Object)shuffleDescriptors.size(), (Matcher)Is.is((Object)100));
        MatcherAssert.assertThat(shuffleDescriptors.stream().map(ShuffleDescriptor::getResultPartitionID).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])resultPartitionIDS.toArray()));
        ResourceManagerPartitionTrackerImplTest.reportEmpty((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_1);
        ResourceManagerPartitionTrackerImplTest.reportEmpty((ResourceManagerPartitionTracker)tracker, TASK_EXECUTOR_ID_2);
        MatcherAssert.assertThat((Object)tracker.areAllMapsEmpty(), (Matcher)Is.is((Object)true));
    }

    private static void reportEmpty(ResourceManagerPartitionTracker tracker, ResourceID ... taskExecutorIds) {
        for (ResourceID taskExecutorId : taskExecutorIds) {
            tracker.processTaskExecutorClusterPartitionReport(taskExecutorId, EMPTY_PARTITION_REPORT);
        }
    }

    private static void report(ResourceManagerPartitionTracker tracker, ResourceID taskExecutorId, IntermediateDataSetID dataSetId, int numTotalPartitions, ResultPartitionID ... partitionIds) {
        tracker.processTaskExecutorClusterPartitionReport(taskExecutorId, ResourceManagerPartitionTrackerImplTest.createClusterPartitionReport(dataSetId, numTotalPartitions, partitionIds));
    }

    private static ClusterPartitionReport createClusterPartitionReport(IntermediateDataSetID dataSetId, int numTotalPartitions, ResultPartitionID ... partitionId) {
        Map<ResultPartitionID, ShuffleDescriptor> shuffleDescriptors = Arrays.stream(partitionId).map(TestShuffleDescriptor::new).collect(Collectors.toMap(TestShuffleDescriptor::getResultPartitionID, d -> d));
        return new ClusterPartitionReport(Collections.singletonList(new ClusterPartitionReport.ClusterPartitionReportEntry(dataSetId, numTotalPartitions, shuffleDescriptors)));
    }

    private static class TestClusterPartitionReleaser
    implements TaskExecutorClusterPartitionReleaser {
        final List<Tuple2<ResourceID, Set<IntermediateDataSetID>>> releaseCalls = new ArrayList<Tuple2<ResourceID, Set<IntermediateDataSetID>>>();

        private TestClusterPartitionReleaser() {
        }

        public void releaseClusterPartitions(ResourceID taskExecutorId, Set<IntermediateDataSetID> dataSetsToRelease) {
            this.releaseCalls.add((Tuple2<ResourceID, Set<IntermediateDataSetID>>)Tuple2.of((Object)taskExecutorId, dataSetsToRelease));
        }
    }

    private static class TestShuffleDescriptor
    implements ShuffleDescriptor {
        private final ResultPartitionID resultPartitionID;

        TestShuffleDescriptor(ResultPartitionID resultPartitionID) {
            this.resultPartitionID = resultPartitionID;
        }

        public ResultPartitionID getResultPartitionID() {
            return this.resultPartitionID;
        }

        public Optional<ResourceID> storesLocalResourcesOn() {
            return Optional.empty();
        }
    }
}

