/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.runtime.executiongraph.DefaultVertexAttemptNumberStore;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DefaultVertexAttemptNumberStoreTest
extends TestLogger {
    @Test
    public void testSetAttemptCount() {
        DefaultVertexAttemptNumberStore vertexAttemptNumberStore = new DefaultVertexAttemptNumberStore();
        JobVertexID jobVertexId = new JobVertexID();
        int subtaskIndex = 4;
        int attemptCount = 2;
        vertexAttemptNumberStore.setAttemptCount(jobVertexId, 4, 2);
        Assert.assertThat((Object)vertexAttemptNumberStore.getAttemptCounts(jobVertexId).getAttemptCount(4), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetAttemptCountRejectsNegativeSubtaskIndex() {
        DefaultVertexAttemptNumberStore vertexAttemptNumberStore = new DefaultVertexAttemptNumberStore();
        vertexAttemptNumberStore.setAttemptCount(new JobVertexID(), -1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetAttemptCountRejectsNegativeAttemptCount() {
        DefaultVertexAttemptNumberStore vertexAttemptNumberStore = new DefaultVertexAttemptNumberStore();
        vertexAttemptNumberStore.setAttemptCount(new JobVertexID(), 0, -1);
    }
}

