/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.SpeculativeExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.SpeculativeExecutionVertex;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.scheduler.InternalFailuresListener;
import org.apache.flink.runtime.scheduler.TestingInternalFailuresListener;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class ArchivedExecutionVertexWithSpeculativeExecutionTest {
    @RegisterExtension
    private static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorExtension();
    private TestingInternalFailuresListener internalFailuresListener;

    ArchivedExecutionVertexWithSpeculativeExecutionTest() {
    }

    @BeforeEach
    void setUp() {
        this.internalFailuresListener = new TestingInternalFailuresListener();
    }

    @Test
    void testCreateSpeculativeExecution() throws Exception {
        SpeculativeExecutionVertex ev = this.createSpeculativeExecutionVertex();
        ev.createNewSpeculativeExecution(System.currentTimeMillis());
        ArchivedExecutionVertex aev = ev.archive();
        ArchivedExecutionGraphTestUtils.compareExecutionVertex((AccessExecutionVertex)ev, (AccessExecutionVertex)aev);
    }

    @Test
    void testResetExecutionVertex() throws Exception {
        SpeculativeExecutionVertex ev = this.createSpeculativeExecutionVertex();
        Execution e1 = ev.getCurrentExecutionAttempt();
        Execution e2 = ev.createNewSpeculativeExecution(System.currentTimeMillis());
        e1.transitionState(ExecutionState.RUNNING);
        e1.markFinished();
        e2.cancel();
        ev.resetForNewExecution();
        ArchivedExecutionVertex aev = ev.archive();
        ArchivedExecutionGraphTestUtils.compareExecutionVertex((AccessExecutionVertex)ev, (AccessExecutionVertex)aev);
    }

    @Test
    void testCancel() throws Exception {
        SpeculativeExecutionVertex ev = this.createSpeculativeExecutionVertex();
        ev.createNewSpeculativeExecution(System.currentTimeMillis());
        ev.cancel();
        ArchivedExecutionVertex aev = ev.archive();
        ArchivedExecutionGraphTestUtils.compareExecutionVertex((AccessExecutionVertex)ev, (AccessExecutionVertex)aev);
    }

    @Test
    void testSuspend() throws Exception {
        SpeculativeExecutionVertex ev = this.createSpeculativeExecutionVertex();
        ev.createNewSpeculativeExecution(System.currentTimeMillis());
        ev.suspend();
        ArchivedExecutionVertex aev = ev.archive();
        ArchivedExecutionGraphTestUtils.compareExecutionVertex((AccessExecutionVertex)ev, (AccessExecutionVertex)aev);
    }

    @Test
    void testFail() throws Exception {
        SpeculativeExecutionVertex ev = this.createSpeculativeExecutionVertex();
        ev.createNewSpeculativeExecution(System.currentTimeMillis());
        ev.fail((Throwable)new Exception("Forced test failure."));
        ArchivedExecutionVertex aev = ev.archive();
        ArchivedExecutionGraphTestUtils.compareExecutionVertex((AccessExecutionVertex)ev, (AccessExecutionVertex)aev);
    }

    @Test
    void testMarkFailed() throws Exception {
        SpeculativeExecutionVertex ev = this.createSpeculativeExecutionVertex();
        ev.createNewSpeculativeExecution(System.currentTimeMillis());
        ev.markFailed((Throwable)new Exception("Forced test failure."));
        ArchivedExecutionVertex aev = ev.archive();
        ArchivedExecutionGraphTestUtils.compareExecutionVertex((AccessExecutionVertex)ev, (AccessExecutionVertex)aev);
    }

    @Test
    void testVertexTerminationAndJobTermination() throws Exception {
        JobVertex jobVertex = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobGraph jobGraph = JobGraphTestUtils.batchJobGraph(jobVertex);
        ExecutionGraph eg = this.createExecutionGraph(jobGraph);
        eg.transitionToRunning();
        ExecutionJobVertex jv = eg.getJobVertex(jobVertex.getID());
        Assertions.assertThat((Object)jv).isNotNull();
        SpeculativeExecutionVertex ev = (SpeculativeExecutionVertex)jv.getTaskVertices()[0];
        Execution e1 = ev.getCurrentExecutionAttempt();
        Execution e2 = ev.createNewSpeculativeExecution(System.currentTimeMillis());
        e1.transitionState(ExecutionState.RUNNING);
        e1.markFinished();
        e2.cancel();
        ArchivedExecutionVertex aev = ev.archive();
        ArchivedExecutionGraphTestUtils.compareExecutionVertex((AccessExecutionVertex)ev, (AccessExecutionVertex)aev);
    }

    @Test
    void testArchiveFailedExecutions() throws Exception {
        SpeculativeExecutionVertex ev = this.createSpeculativeExecutionVertex();
        Execution e1 = ev.getCurrentExecutionAttempt();
        e1.transitionState(ExecutionState.RUNNING);
        Execution e2 = ev.createNewSpeculativeExecution(0L);
        e2.transitionState(ExecutionState.FAILED);
        ev.archiveFailedExecution(e2.getAttemptId());
        Execution e3 = ev.createNewSpeculativeExecution(0L);
        e3.transitionState(ExecutionState.RUNNING);
        e1.transitionState(ExecutionState.FAILED);
        ev.archiveFailedExecution(e1.getAttemptId());
        ArchivedExecutionVertex aev = ev.archive();
        ArchivedExecutionGraphTestUtils.compareExecutionVertex((AccessExecutionVertex)ev, (AccessExecutionVertex)aev);
    }

    @Test
    void testArchiveTheOnlyCurrentExecution() throws Exception {
        SpeculativeExecutionVertex ev = this.createSpeculativeExecutionVertex();
        Execution e1 = ev.getCurrentExecutionAttempt();
        e1.transitionState(ExecutionState.FAILED);
        ev.archiveFailedExecution(e1.getAttemptId());
        ArchivedExecutionVertex aev = ev.archive();
        ArchivedExecutionGraphTestUtils.compareExecutionVertex((AccessExecutionVertex)ev, (AccessExecutionVertex)aev);
    }

    @Test
    void testGetExecutionState() throws Exception {
        SpeculativeExecutionVertex ev = this.createSpeculativeExecutionVertex();
        Execution e1 = ev.getCurrentExecutionAttempt();
        e1.transitionState(ExecutionState.CANCELED);
        ArrayList<ExecutionState> statesSortedByPriority = new ArrayList<ExecutionState>();
        statesSortedByPriority.add(ExecutionState.FAILED);
        statesSortedByPriority.add(ExecutionState.CANCELING);
        statesSortedByPriority.add(ExecutionState.CREATED);
        statesSortedByPriority.add(ExecutionState.SCHEDULED);
        statesSortedByPriority.add(ExecutionState.DEPLOYING);
        statesSortedByPriority.add(ExecutionState.INITIALIZING);
        statesSortedByPriority.add(ExecutionState.RUNNING);
        statesSortedByPriority.add(ExecutionState.FINISHED);
        for (ExecutionState state : statesSortedByPriority) {
            Execution execution = ev.createNewSpeculativeExecution(0L);
            execution.transitionState(state);
            ArchivedExecutionVertex aev = ev.archive();
            ArchivedExecutionGraphTestUtils.compareExecutionVertex((AccessExecutionVertex)ev, (AccessExecutionVertex)aev);
        }
    }

    private SpeculativeExecutionVertex createSpeculativeExecutionVertex() throws Exception {
        JobVertex jobVertex = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobGraph jobGraph = JobGraphTestUtils.batchJobGraph(jobVertex);
        ExecutionGraph executionGraph = this.createExecutionGraph(jobGraph);
        ExecutionJobVertex jv = executionGraph.getJobVertex(jobVertex.getID());
        Assertions.assertThat((Object)jv).isNotNull();
        return (SpeculativeExecutionVertex)jv.getTaskVertices()[0];
    }

    private ExecutionGraph createExecutionGraph(JobGraph jobGraph) throws Exception {
        DefaultExecutionGraph executionGraph = TestingDefaultExecutionGraphBuilder.newBuilder().setJobGraph(jobGraph).setExecutionJobVertexFactory((ExecutionJobVertex.Factory)new SpeculativeExecutionJobVertex.Factory()).build((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor());
        executionGraph.setInternalTaskFailuresListener((InternalFailuresListener)this.internalFailuresListener);
        executionGraph.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
        return executionGraph;
    }
}

