/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;

public class ConsumedPartitionGroup
implements Iterable<IntermediateResultPartitionID> {
    private final List<IntermediateResultPartitionID> resultPartitions;
    private final AtomicInteger unfinishedPartitions;
    private final IntermediateDataSetID intermediateDataSetID;
    private final ResultPartitionType resultPartitionType;
    private final int numConsumers;

    private ConsumedPartitionGroup(int numConsumers, List<IntermediateResultPartitionID> resultPartitions, ResultPartitionType resultPartitionType) {
        Preconditions.checkArgument((resultPartitions.size() > 0 ? 1 : 0) != 0, (Object)"The size of result partitions in the ConsumedPartitionGroup should be larger than 0.");
        this.numConsumers = numConsumers;
        this.intermediateDataSetID = resultPartitions.get(0).getIntermediateDataSetID();
        this.resultPartitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)resultPartitionType)));
        for (IntermediateResultPartitionID resultPartition : resultPartitions) {
            Preconditions.checkArgument((boolean)resultPartition.getIntermediateDataSetID().equals(this.intermediateDataSetID));
        }
        this.resultPartitions = resultPartitions;
        this.unfinishedPartitions = new AtomicInteger(resultPartitions.size());
    }

    public static ConsumedPartitionGroup fromMultiplePartitions(int numConsumers, List<IntermediateResultPartitionID> resultPartitions, ResultPartitionType resultPartitionType) {
        return new ConsumedPartitionGroup(numConsumers, resultPartitions, resultPartitionType);
    }

    public static ConsumedPartitionGroup fromSinglePartition(int numConsumers, IntermediateResultPartitionID resultPartition, ResultPartitionType resultPartitionType) {
        return new ConsumedPartitionGroup(numConsumers, Collections.singletonList(resultPartition), resultPartitionType);
    }

    @Override
    public Iterator<IntermediateResultPartitionID> iterator() {
        return this.resultPartitions.iterator();
    }

    public int size() {
        return this.resultPartitions.size();
    }

    public boolean isEmpty() {
        return this.resultPartitions.isEmpty();
    }

    public int getNumConsumers() {
        return this.numConsumers;
    }

    public IntermediateResultPartitionID getFirst() {
        return this.iterator().next();
    }

    public IntermediateDataSetID getIntermediateDataSetID() {
        return this.intermediateDataSetID;
    }

    public int partitionUnfinished() {
        return this.unfinishedPartitions.incrementAndGet();
    }

    public int partitionFinished() {
        return this.unfinishedPartitions.decrementAndGet();
    }

    @VisibleForTesting
    public int getNumberOfUnfinishedPartitions() {
        return this.unfinishedPartitions.get();
    }

    public boolean areAllPartitionsFinished() {
        return this.unfinishedPartitions.get() == 0;
    }

    public ResultPartitionType getResultPartitionType() {
        return this.resultPartitionType;
    }
}

