/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.InternalExecutionGraphAccessor;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.Preconditions;

public class IntermediateResult {
    private final IntermediateDataSet intermediateDataSet;
    private final IntermediateDataSetID id;
    private final ExecutionJobVertex producer;
    private final IntermediateResultPartition[] partitions;
    private final HashMap<IntermediateResultPartitionID, Integer> partitionLookupHelper = new HashMap();
    private final int numParallelProducers;
    private int partitionsAssigned;
    private final int connectionIndex;
    private final ResultPartitionType resultType;
    private final Map<ConsumedPartitionGroup, TaskDeploymentDescriptor.MaybeOffloaded<ShuffleDescriptor[]>> shuffleDescriptorCache;
    private final List<JobVertexID> consumerVertices = new ArrayList<JobVertexID>();

    public IntermediateResult(IntermediateDataSet intermediateDataSet, ExecutionJobVertex producer, int numParallelProducers, ResultPartitionType resultType) {
        this.intermediateDataSet = (IntermediateDataSet)Preconditions.checkNotNull((Object)intermediateDataSet);
        this.id = (IntermediateDataSetID)Preconditions.checkNotNull((Object)intermediateDataSet.getId());
        this.producer = (ExecutionJobVertex)Preconditions.checkNotNull((Object)producer);
        Preconditions.checkArgument((numParallelProducers >= 1 ? 1 : 0) != 0);
        this.numParallelProducers = numParallelProducers;
        this.partitions = new IntermediateResultPartition[numParallelProducers];
        this.connectionIndex = (int)(Math.random() * 2.147483647E9);
        this.resultType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)resultType)));
        this.shuffleDescriptorCache = new HashMap<ConsumedPartitionGroup, TaskDeploymentDescriptor.MaybeOffloaded<ShuffleDescriptor[]>>();
        intermediateDataSet.getConsumers().forEach(jobEdge -> this.consumerVertices.add(jobEdge.getTarget().getID()));
    }

    public void setPartition(int partitionNumber, IntermediateResultPartition partition) {
        if (partition == null || partitionNumber < 0 || partitionNumber >= this.numParallelProducers) {
            throw new IllegalArgumentException();
        }
        if (this.partitions[partitionNumber] != null) {
            throw new IllegalStateException("Partition #" + partitionNumber + " has already been assigned.");
        }
        this.partitions[partitionNumber] = partition;
        this.partitionLookupHelper.put(partition.getPartitionId(), partitionNumber);
        ++this.partitionsAssigned;
    }

    public IntermediateDataSetID getId() {
        return this.id;
    }

    public ExecutionJobVertex getProducer() {
        return this.producer;
    }

    public IntermediateResultPartition[] getPartitions() {
        return this.partitions;
    }

    public List<JobVertexID> getConsumerVertices() {
        return this.consumerVertices;
    }

    public IntermediateResultPartition getPartitionById(IntermediateResultPartitionID resultPartitionId) {
        Integer partitionNumber = this.partitionLookupHelper.get(Preconditions.checkNotNull((Object)resultPartitionId, (String)"IntermediateResultPartitionID"));
        if (partitionNumber != null) {
            return this.partitions[partitionNumber];
        }
        throw new IllegalArgumentException("Unknown intermediate result partition ID " + resultPartitionId);
    }

    public int getNumberOfAssignedPartitions() {
        return this.partitionsAssigned;
    }

    public ResultPartitionType getResultType() {
        return this.resultType;
    }

    int getNumParallelProducers() {
        return this.numParallelProducers;
    }

    int getConsumersParallelism() {
        List<JobEdge> consumers = this.intermediateDataSet.getConsumers();
        Preconditions.checkState((!consumers.isEmpty() ? 1 : 0) != 0);
        InternalExecutionGraphAccessor graph = this.getProducer().getGraph();
        int consumersParallelism = graph.getJobVertex(consumers.get(0).getTarget().getID()).getParallelism();
        if (consumers.size() == 1) {
            return consumersParallelism;
        }
        for (JobVertexID jobVertexID : this.consumerVertices) {
            Preconditions.checkState((consumersParallelism == graph.getJobVertex(jobVertexID).getParallelism() ? 1 : 0) != 0, (Object)"Consumers must have the same parallelism.");
        }
        return consumersParallelism;
    }

    int getConsumersMaxParallelism() {
        List<JobEdge> consumers = this.intermediateDataSet.getConsumers();
        Preconditions.checkState((!consumers.isEmpty() ? 1 : 0) != 0);
        InternalExecutionGraphAccessor graph = this.getProducer().getGraph();
        int consumersMaxParallelism = graph.getJobVertex(consumers.get(0).getTarget().getID()).getMaxParallelism();
        if (consumers.size() == 1) {
            return consumersMaxParallelism;
        }
        for (JobVertexID jobVertexID : this.consumerVertices) {
            Preconditions.checkState((consumersMaxParallelism == graph.getJobVertex(jobVertexID).getMaxParallelism() ? 1 : 0) != 0, (Object)"Consumers must have the same max parallelism.");
        }
        return consumersMaxParallelism;
    }

    public DistributionPattern getConsumingDistributionPattern() {
        return this.intermediateDataSet.getDistributionPattern();
    }

    public boolean isBroadcast() {
        return this.intermediateDataSet.isBroadcast();
    }

    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    @VisibleForTesting
    void resetForNewExecution() {
        for (IntermediateResultPartition partition : this.partitions) {
            partition.resetForNewExecution();
        }
    }

    public TaskDeploymentDescriptor.MaybeOffloaded<ShuffleDescriptor[]> getCachedShuffleDescriptors(ConsumedPartitionGroup consumedPartitionGroup) {
        return this.shuffleDescriptorCache.get(consumedPartitionGroup);
    }

    public void cacheShuffleDescriptors(ConsumedPartitionGroup consumedPartitionGroup, TaskDeploymentDescriptor.MaybeOffloaded<ShuffleDescriptor[]> shuffleDescriptors) {
        this.shuffleDescriptorCache.put(consumedPartitionGroup, shuffleDescriptors);
    }

    public void clearCachedInformationForPartitionGroup(ConsumedPartitionGroup consumedPartitionGroup) {
        TaskDeploymentDescriptor.MaybeOffloaded<ShuffleDescriptor[]> cache = this.shuffleDescriptorCache.remove(consumedPartitionGroup);
        if (cache instanceof TaskDeploymentDescriptor.Offloaded) {
            PermanentBlobKey blobKey = ((TaskDeploymentDescriptor.Offloaded)cache).serializedValueKey;
            this.producer.getGraph().deleteBlobs(Collections.singletonList(blobKey));
        }
    }

    public String toString() {
        return "IntermediateResult " + this.id.toString();
    }
}

