/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.registration.RegisteredRpcConnection;
import org.apache.flink.runtime.registration.RegistrationConnectionListener;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.TaskExecutorRegistration;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.taskexecutor.TaskExecutorMemoryConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationRejection;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationSuccess;
import org.apache.flink.runtime.taskexecutor.TaskExecutorToResourceManagerConnection;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskExecutorToResourceManagerConnectionTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskExecutorToResourceManagerConnectionTest.class);
    private static final int TEST_TIMEOUT_MILLIS = 10000;
    private static final String RESOURCE_MANAGER_ADDRESS = "localhost";
    private static final ResourceManagerId RESOURCE_MANAGER_ID = ResourceManagerId.generate();
    private static final String TASK_MANAGER_ADDRESS = "localhost";
    private static final ResourceID TASK_MANAGER_RESOURCE_ID = ResourceID.generate();
    private static final int TASK_MANAGER_DATA_PORT = 12345;
    private static final int TASK_MANAGER_JMX_PORT = 23456;
    private static final String TASK_MANAGER_NODE_ID = "local";
    private static final HardwareDescription TASK_MANAGER_HARDWARE_DESCRIPTION = HardwareDescription.extractFromSystem((long)Long.MAX_VALUE);
    private static final TaskExecutorMemoryConfiguration TASK_MANAGER_MEMORY_CONFIGURATION = new TaskExecutorMemoryConfiguration(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L), Long.valueOf(6L), Long.valueOf(7L), Long.valueOf(8L), Long.valueOf(9L), Long.valueOf(10L));
    private TestingRpcService rpcService;
    private TestingResourceManagerGateway testingResourceManagerGateway;
    private CompletableFuture<Void> registrationSuccessFuture;
    private CompletableFuture<Void> registrationRejectionFuture;

    TaskExecutorToResourceManagerConnectionTest() {
    }

    @Test
    void testResourceManagerRegistration() throws Exception {
        TaskExecutorToResourceManagerConnection resourceManagerRegistration = this.createTaskExecutorToResourceManagerConnection();
        this.testingResourceManagerGateway.setRegisterTaskExecutorFunction(taskExecutorRegistration -> {
            String actualAddress = taskExecutorRegistration.getTaskExecutorAddress();
            ResourceID actualResourceId = taskExecutorRegistration.getResourceId();
            Integer actualDataPort = taskExecutorRegistration.getDataPort();
            HardwareDescription actualHardwareDescription = taskExecutorRegistration.getHardwareDescription();
            TaskExecutorMemoryConfiguration actualMemoryConfiguration = taskExecutorRegistration.getMemoryConfiguration();
            String nodeID = taskExecutorRegistration.getNodeId();
            Assertions.assertThat((String)actualAddress).isEqualTo("localhost");
            Assertions.assertThat((Object)actualResourceId).isEqualTo((Object)TASK_MANAGER_RESOURCE_ID);
            Assertions.assertThat((Integer)actualDataPort).isEqualTo(12345);
            Assertions.assertThat((Object)actualHardwareDescription).isEqualTo((Object)TASK_MANAGER_HARDWARE_DESCRIPTION);
            Assertions.assertThat((Object)actualMemoryConfiguration).isEqualTo((Object)TASK_MANAGER_MEMORY_CONFIGURATION);
            Assertions.assertThat((String)nodeID).isEqualTo(TASK_MANAGER_NODE_ID);
            return CompletableFuture.completedFuture(TaskExecutorToResourceManagerConnectionTest.successfulRegistration());
        });
        resourceManagerRegistration.start();
        this.registrationSuccessFuture.get(10000L, TimeUnit.MILLISECONDS);
    }

    @Test
    void testResourceManagerRegistrationIsRejected() {
        TaskExecutorToResourceManagerConnection resourceManagerRegistration = this.createTaskExecutorToResourceManagerConnection();
        this.testingResourceManagerGateway.setRegisterTaskExecutorFunction(taskExecutorRegistration -> CompletableFuture.completedFuture(new TaskExecutorRegistrationRejection("Foobar")));
        resourceManagerRegistration.start();
        this.registrationRejectionFuture.join();
    }

    private TaskExecutorToResourceManagerConnection createTaskExecutorToResourceManagerConnection() {
        TaskExecutorRegistration taskExecutorRegistration = new TaskExecutorRegistration("localhost", TASK_MANAGER_RESOURCE_ID, 12345, 23456, TASK_MANAGER_HARDWARE_DESCRIPTION, TASK_MANAGER_MEMORY_CONFIGURATION, ResourceProfile.ZERO, ResourceProfile.ZERO, TASK_MANAGER_NODE_ID);
        return new TaskExecutorToResourceManagerConnection(LOGGER, (RpcService)this.rpcService, RetryingRegistrationConfiguration.defaultConfiguration(), "localhost", RESOURCE_MANAGER_ID, Executors.directExecutor(), new TestRegistrationConnectionListener(), taskExecutorRegistration);
    }

    private static TaskExecutorRegistrationSuccess successfulRegistration() {
        return new TaskExecutorRegistrationSuccess(new InstanceID(), ResourceID.generate(), new ClusterInformation("blobServerHost", 55555));
    }

    @BeforeEach
    void setUp() {
        this.rpcService = new TestingRpcService();
        this.testingResourceManagerGateway = new TestingResourceManagerGateway();
        this.rpcService.registerGateway("localhost", (RpcGateway)this.testingResourceManagerGateway);
        this.registrationSuccessFuture = new CompletableFuture();
        this.registrationRejectionFuture = new CompletableFuture();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.rpcService.stopService().get(10000L, TimeUnit.MILLISECONDS);
    }

    private class TestRegistrationConnectionListener<T extends RegisteredRpcConnection<?, ?, S, ?>, S extends RegistrationResponse.Success, R extends RegistrationResponse.Rejection>
    implements RegistrationConnectionListener<T, S, R> {
        private TestRegistrationConnectionListener() {
        }

        public void onRegistrationSuccess(T connection, S success) {
            TaskExecutorToResourceManagerConnectionTest.this.registrationSuccessFuture.complete(null);
        }

        public void onRegistrationFailure(Throwable failure) {
            TaskExecutorToResourceManagerConnectionTest.this.registrationSuccessFuture.completeExceptionally(failure);
        }

        public void onRegistrationRejection(String targetAddress, R rejection) {
            TaskExecutorToResourceManagerConnectionTest.this.registrationRejectionFuture.complete(null);
        }
    }
}

