/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.runtime.state.InternalPriorityQueueTestBase;
import org.apache.flink.runtime.state.heap.HeapPriorityQueue;
import org.junit.Assert;
import org.junit.Test;

public class HeapPriorityQueueTest
extends InternalPriorityQueueTestBase {
    @Test
    public void testClear() {
        HeapPriorityQueue<InternalPriorityQueueTestBase.TestElement> priorityQueueSet = this.newPriorityQueue(1);
        int count = 10;
        HashSet<InternalPriorityQueueTestBase.TestElement> checkSet = new HashSet<InternalPriorityQueueTestBase.TestElement>(count);
        HeapPriorityQueueTest.insertRandomElements(priorityQueueSet, checkSet, count);
        Assert.assertEquals((long)count, (long)priorityQueueSet.size());
        priorityQueueSet.clear();
        Assert.assertEquals((long)0L, (long)priorityQueueSet.size());
    }

    @Test
    public void testToArray() {
        int testSize = 10;
        ArrayList<InternalPriorityQueueTestBase.TestElement[]> tests = new ArrayList<InternalPriorityQueueTestBase.TestElement[]>(2);
        tests.add(new InternalPriorityQueueTestBase.TestElement[0]);
        tests.add(new InternalPriorityQueueTestBase.TestElement[10]);
        tests.add(new InternalPriorityQueueTestBase.TestElement[11]);
        for (Object[] objectArray : tests) {
            Arrays.fill(objectArray, new InternalPriorityQueueTestBase.TestElement(42L, 4711L));
            HashSet<InternalPriorityQueueTestBase.TestElement> checkSet = new HashSet<InternalPriorityQueueTestBase.TestElement>(10);
            HeapPriorityQueue<InternalPriorityQueueTestBase.TestElement> timerPriorityQueue = this.newPriorityQueue(1);
            Assert.assertEquals((long)objectArray.length, (long)((InternalPriorityQueueTestBase.TestElement[])timerPriorityQueue.toArray(objectArray)).length);
            HeapPriorityQueueTest.insertRandomElements(timerPriorityQueue, checkSet, 10);
            InternalPriorityQueueTestBase.TestElement[] toArray = (InternalPriorityQueueTestBase.TestElement[])timerPriorityQueue.toArray(objectArray);
            Assert.assertEquals((Object)(objectArray.length >= 10 ? 1 : 0), (Object)(objectArray == toArray ? 1 : 0));
            int count = 0;
            for (InternalPriorityQueueTestBase.TestElement o : toArray) {
                if (o == null) break;
                Assert.assertTrue((boolean)checkSet.remove(o));
                ++count;
            }
            Assert.assertEquals((long)timerPriorityQueue.size(), (long)count);
            Assert.assertTrue((boolean)checkSet.isEmpty());
        }
    }

    protected HeapPriorityQueue<InternalPriorityQueueTestBase.TestElement> newPriorityQueue(int initialCapacity) {
        return new HeapPriorityQueue(TEST_ELEMENT_PRIORITY_COMPARATOR, initialCapacity);
    }

    @Override
    protected boolean testSetSemanticsAgainstDuplicateElements() {
        return false;
    }
}

