/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.time.Duration;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.AnyMatchingSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotMatchingStrategy;
import org.apache.flink.testutils.TestingUtils;

public class SlotManagerConfigurationBuilder {
    private Time taskManagerRequestTimeout = TestingUtils.infiniteTime();
    private Time slotRequestTimeout = TestingUtils.infiniteTime();
    private Time taskManagerTimeout = TestingUtils.infiniteTime();
    private Duration requirementCheckDelay = (Duration)ResourceManagerOptions.REQUIREMENTS_CHECK_DELAY.defaultValue();
    private boolean waitResultConsumedBeforeRelease = true;
    private WorkerResourceSpec defaultWorkerResourceSpec = WorkerResourceSpec.ZERO;
    private int numSlotsPerWorker = 1;
    private int maxSlotNum = (Integer)ResourceManagerOptions.MAX_SLOT_NUM.defaultValue();
    private CPUResource maxTotalCpu = new CPUResource(Double.MAX_VALUE);
    private MemorySize maxTotalMem = MemorySize.MAX_VALUE;
    private int redundantTaskManagerNum = (Integer)ResourceManagerOptions.REDUNDANT_TASK_MANAGER_NUM.defaultValue();

    private SlotManagerConfigurationBuilder() {
    }

    public static SlotManagerConfigurationBuilder newBuilder() {
        return new SlotManagerConfigurationBuilder();
    }

    public SlotManagerConfigurationBuilder setTaskManagerRequestTimeout(Time taskManagerRequestTimeout) {
        this.taskManagerRequestTimeout = taskManagerRequestTimeout;
        return this;
    }

    public SlotManagerConfigurationBuilder setSlotRequestTimeout(Time slotRequestTimeout) {
        this.slotRequestTimeout = slotRequestTimeout;
        return this;
    }

    public SlotManagerConfigurationBuilder setTaskManagerTimeout(Time taskManagerTimeout) {
        this.taskManagerTimeout = taskManagerTimeout;
        return this;
    }

    public SlotManagerConfigurationBuilder setRequirementCheckDelay(Duration requirementCheckDelay) {
        this.requirementCheckDelay = requirementCheckDelay;
        return this;
    }

    public SlotManagerConfigurationBuilder setWaitResultConsumedBeforeRelease(boolean waitResultConsumedBeforeRelease) {
        this.waitResultConsumedBeforeRelease = waitResultConsumedBeforeRelease;
        return this;
    }

    public SlotManagerConfigurationBuilder setDefaultWorkerResourceSpec(WorkerResourceSpec defaultWorkerResourceSpec) {
        this.defaultWorkerResourceSpec = defaultWorkerResourceSpec;
        return this;
    }

    public SlotManagerConfigurationBuilder setNumSlotsPerWorker(int numSlotsPerWorker) {
        this.numSlotsPerWorker = numSlotsPerWorker;
        return this;
    }

    public SlotManagerConfigurationBuilder setMaxSlotNum(int maxSlotNum) {
        this.maxSlotNum = maxSlotNum;
        return this;
    }

    public SlotManagerConfigurationBuilder setMaxTotalCpu(CPUResource maxTotalCpu) {
        this.maxTotalCpu = maxTotalCpu;
        return this;
    }

    public SlotManagerConfigurationBuilder setMaxTotalMem(MemorySize maxTotalMem) {
        this.maxTotalMem = maxTotalMem;
        return this;
    }

    public SlotManagerConfigurationBuilder setRedundantTaskManagerNum(int redundantTaskManagerNum) {
        this.redundantTaskManagerNum = redundantTaskManagerNum;
        return this;
    }

    public SlotManagerConfiguration build() {
        return new SlotManagerConfiguration(this.taskManagerRequestTimeout, this.slotRequestTimeout, this.taskManagerTimeout, this.requirementCheckDelay, this.waitResultConsumedBeforeRelease, (SlotMatchingStrategy)AnyMatchingSlotMatchingStrategy.INSTANCE, this.defaultWorkerResourceSpec, this.numSlotsPerWorker, this.maxSlotNum, this.maxTotalCpu, this.maxTotalMem, this.redundantTaskManagerNum);
    }
}

