/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.query.KvStateLocationRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class KvStateLocationRegistryTest {
    @Test
    public void testRegisterAndLookup() throws Exception {
        int keyGroupIndex;
        int i;
        String[] registrationNames = new String[]{"TAsIrGnc7MULwVupNKZ0", "086133IrGn0Ii2853237"};
        ExecutionJobVertex[] vertices = new ExecutionJobVertex[]{this.createJobVertex(32), this.createJobVertex(13)};
        KvStateID[][] ids = new KvStateID[vertices.length][];
        for (int i2 = 0; i2 < ids.length; ++i2) {
            ids[i2] = new KvStateID[vertices[i2].getMaxParallelism()];
            for (int j = 0; j < vertices[i2].getMaxParallelism(); ++j) {
                ids[i2][j] = new KvStateID();
            }
        }
        InetSocketAddress server = new InetSocketAddress(InetAddress.getLocalHost(), 12032);
        Map<JobVertexID, ExecutionJobVertex> vertexMap = this.createVertexMap(vertices);
        KvStateLocationRegistry registry = new KvStateLocationRegistry(new JobID(), vertexMap);
        for (i = 0; i < vertices.length; ++i) {
            int numKeyGroups = vertices[i].getMaxParallelism();
            for (int keyGroupIndex2 = 0; keyGroupIndex2 < numKeyGroups; ++keyGroupIndex2) {
                registry.notifyKvStateRegistered(vertices[i].getJobVertexId(), new KeyGroupRange(keyGroupIndex2, keyGroupIndex2), registrationNames[i], ids[i][keyGroupIndex2], server);
            }
        }
        for (i = 0; i < vertices.length; ++i) {
            KvStateLocation location = registry.getKvStateLocation(registrationNames[i]);
            Assert.assertNotNull((Object)location);
            int maxParallelism = vertices[i].getMaxParallelism();
            for (keyGroupIndex = 0; keyGroupIndex < maxParallelism; ++keyGroupIndex) {
                Assert.assertEquals((Object)ids[i][keyGroupIndex], (Object)location.getKvStateID(keyGroupIndex));
                Assert.assertEquals((Object)server, (Object)location.getKvStateServerAddress(keyGroupIndex));
            }
        }
        for (i = 0; i < vertices.length; ++i) {
            int numKeyGroups = vertices[i].getMaxParallelism();
            JobVertexID jobVertexId = vertices[i].getJobVertexId();
            for (keyGroupIndex = 0; keyGroupIndex < numKeyGroups; ++keyGroupIndex) {
                registry.notifyKvStateUnregistered(jobVertexId, new KeyGroupRange(keyGroupIndex, keyGroupIndex), registrationNames[i]);
            }
        }
        for (i = 0; i < registrationNames.length; ++i) {
            Assert.assertNull((Object)registry.getKvStateLocation(registrationNames[i]));
        }
    }

    @Test
    public void testRegisterDuplicateName() throws Exception {
        ExecutionJobVertex[] vertices = new ExecutionJobVertex[]{this.createJobVertex(32), this.createJobVertex(13)};
        Map<JobVertexID, ExecutionJobVertex> vertexMap = this.createVertexMap(vertices);
        String registrationName = "duplicated-name";
        KvStateLocationRegistry registry = new KvStateLocationRegistry(new JobID(), vertexMap);
        registry.notifyKvStateRegistered(vertices[0].getJobVertexId(), new KeyGroupRange(0, 0), registrationName, new KvStateID(), new InetSocketAddress(InetAddress.getLocalHost(), 12328));
        try {
            registry.notifyKvStateRegistered(vertices[1].getJobVertexId(), new KeyGroupRange(0, 0), registrationName, new KvStateID(), new InetSocketAddress(InetAddress.getLocalHost(), 12032));
            Assert.fail((String)"Did not throw expected Exception after duplicated name");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testUnregisterBeforeRegister() throws Exception {
        ExecutionJobVertex vertex = this.createJobVertex(4);
        Map<JobVertexID, ExecutionJobVertex> vertexMap = this.createVertexMap(vertex);
        KvStateLocationRegistry registry = new KvStateLocationRegistry(new JobID(), vertexMap);
        try {
            registry.notifyKvStateUnregistered(vertex.getJobVertexId(), new KeyGroupRange(0, 0), "any-name");
            Assert.fail((String)"Did not throw expected Exception, because of missing registration");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnregisterFailures() throws Exception {
        String name = "IrGnc73237TAs";
        ExecutionJobVertex[] vertices = new ExecutionJobVertex[]{this.createJobVertex(32), this.createJobVertex(13)};
        HashMap<JobVertexID, ExecutionJobVertex> vertexMap = new HashMap<JobVertexID, ExecutionJobVertex>();
        for (ExecutionJobVertex vertex : vertices) {
            vertexMap.put(vertex.getJobVertexId(), vertex);
        }
        KvStateLocationRegistry registry = new KvStateLocationRegistry(new JobID(), vertexMap);
        registry.notifyKvStateRegistered(vertices[0].getJobVertexId(), new KeyGroupRange(0, 0), name, new KvStateID(), (InetSocketAddress)Mockito.mock(InetSocketAddress.class));
        try {
            int notRegisteredKeyGroupIndex = 2;
            registry.notifyKvStateUnregistered(vertices[0].getJobVertexId(), new KeyGroupRange(notRegisteredKeyGroupIndex, notRegisteredKeyGroupIndex), name);
            Assert.fail((String)"Did not throw expected Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            registry.notifyKvStateUnregistered(vertices[1].getJobVertexId(), new KeyGroupRange(0, 0), name);
            Assert.fail((String)"Did not throw expected Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private ExecutionJobVertex createJobVertex(int maxParallelism) {
        JobVertexID id = new JobVertexID();
        ExecutionJobVertex vertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        Mockito.when((Object)vertex.getJobVertexId()).thenReturn((Object)id);
        Mockito.when((Object)vertex.getMaxParallelism()).thenReturn((Object)maxParallelism);
        return vertex;
    }

    private Map<JobVertexID, ExecutionJobVertex> createVertexMap(ExecutionJobVertex ... vertices) {
        HashMap<JobVertexID, ExecutionJobVertex> vertexMap = new HashMap<JobVertexID, ExecutionJobVertex>();
        for (ExecutionJobVertex vertex : vertices) {
            vertexMap.put(vertex.getJobVertexId(), vertex);
        }
        return vertexMap;
    }
}

