/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils.types;

import java.io.DataInput;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.StringComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.operators.testutils.types.StringPair;
import org.apache.flink.types.StringValue;

public class StringPairComparator
extends TypeComparator<StringPair> {
    private static final long serialVersionUID = 1L;
    private String reference;
    private final TypeComparator[] comparators = new TypeComparator[]{new StringComparator(true)};

    public int hash(StringPair record) {
        return record.getKey().hashCode();
    }

    public void setReference(StringPair toCompare) {
        this.reference = toCompare.getKey();
    }

    public boolean equalToReference(StringPair candidate) {
        return this.reference.equals(candidate.getKey());
    }

    public int compareToReference(TypeComparator<StringPair> referencedComparator) {
        return this.reference.compareTo(((StringPairComparator)referencedComparator).reference);
    }

    public int compare(StringPair first, StringPair second) {
        return first.getKey().compareTo(second.getKey());
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        return StringValue.readString((DataInput)firstSource).compareTo(StringValue.readString((DataInput)secondSource));
    }

    public boolean supportsNormalizedKey() {
        return false;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public int getNormalizeKeyLen() {
        return Integer.MAX_VALUE;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return false;
    }

    public void putNormalizedKey(StringPair record, MemorySegment target, int offset, int numBytes) {
        throw new RuntimeException("not implemented");
    }

    public void writeWithKeyNormalization(StringPair record, DataOutputView target) throws IOException {
        throw new RuntimeException("not implemented");
    }

    public StringPair readWithKeyDenormalization(StringPair record, DataInputView source) throws IOException {
        throw new RuntimeException("not implemented");
    }

    public boolean invertNormalizedKey() {
        return false;
    }

    public TypeComparator<StringPair> duplicate() {
        return new StringPairComparator();
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = ((StringPair)record).getKey();
        return 1;
    }

    public TypeComparator[] getFlatComparators() {
        return this.comparators;
    }
}

