/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.core.testutils.BlockerSync;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.CollectingMetricsReporter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.FrontMetricGroup;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.apache.flink.runtime.metrics.groups.ProcessMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class AbstractMetricGroupTest
extends TestLogger {
    private static final CharacterFilter FILTER_C = new CharacterFilter(){

        public String filterCharacters(String input) {
            return input.replace("C", "X");
        }
    };
    private static final CharacterFilter FILTER_B = new CharacterFilter(){

        public String filterCharacters(String input) {
            return input.replace("B", "X");
        }
    };

    @Test
    public void testGetAllVariables() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        AbstractMetricGroup group = new AbstractMetricGroup<AbstractMetricGroup<?>>((MetricRegistry)registry, new String[0], null){

            protected QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
                return null;
            }

            protected String getGroupName(CharacterFilter filter) {
                return "";
            }
        };
        Assert.assertTrue((boolean)group.getAllVariables().isEmpty());
        registry.shutdown().get();
    }

    @Test
    public void testGetAllVariablesWithOutExclusions() {
        MetricRegistry registry = NoOpMetricRegistry.INSTANCE;
        ProcessMetricGroup group = new ProcessMetricGroup(registry, "host");
        MatcherAssert.assertThat((Object)group.getAllVariables(), (Matcher)IsMapContaining.hasKey((Object)ScopeFormat.SCOPE_HOST));
    }

    @Test
    public void testGetAllVariablesWithExclusions() {
        MetricRegistry registry = NoOpMetricRegistry.INSTANCE;
        ProcessMetricGroup group = new ProcessMetricGroup(registry, "host");
        Assert.assertEquals((long)group.getAllVariables(-1, Collections.singleton(ScopeFormat.SCOPE_HOST)).size(), (long)0L);
    }

    @Test
    public void testGetAllVariablesWithExclusionsForReporters() {
        TestingMetricRegistry registry = TestingMetricRegistry.builder().setNumberReporters(2).build();
        GenericMetricGroup group = new GenericMetricGroup(registry, null, "test"){

            protected void putVariables(Map<String, String> variables) {
                variables.put("k1", "v1");
                variables.put("k2", "v2");
            }
        };
        group.getAllVariables(-1, Collections.emptySet());
        MatcherAssert.assertThat((Object)group.getAllVariables(0, Collections.singleton("k1")), (Matcher)IsNot.not((Matcher)IsMapContaining.hasKey((Object)"k1")));
        MatcherAssert.assertThat((Object)group.getAllVariables(0, Collections.singleton("k1")), (Matcher)IsMapContaining.hasKey((Object)"k2"));
        MatcherAssert.assertThat((Object)group.getAllVariables(1, Collections.singleton("k2")), (Matcher)IsMapContaining.hasKey((Object)"k1"));
        MatcherAssert.assertThat((Object)group.getAllVariables(1, Collections.singleton("k2")), (Matcher)IsNot.not((Matcher)IsMapContaining.hasKey((Object)"k2")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScopeCachingForMultipleReporters() throws Exception {
        String counterName = "1";
        Configuration config = new Configuration();
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A.B.C.D");
        MetricConfig metricConfig1 = new MetricConfig();
        metricConfig1.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "-");
        MetricConfig metricConfig2 = new MetricConfig();
        metricConfig2.setProperty(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "!");
        config.setString("metrics.reporter.test1." + MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "-");
        config.setString("metrics.reporter.test2." + MetricOptions.REPORTER_SCOPE_DELIMITER.key(), "!");
        CollectingMetricsReporter reporter1 = new CollectingMetricsReporter(FILTER_B);
        CollectingMetricsReporter reporter2 = new CollectingMetricsReporter(FILTER_C);
        MetricRegistryImpl testRegistry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(config), Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricConfig)metricConfig1, (MetricReporter)reporter1), ReporterSetup.forReporter((String)"test2", (MetricConfig)metricConfig2, (MetricReporter)reporter2)));
        try {
            TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)testRegistry, (String)"host", (ResourceID)new ResourceID("id"));
            tmGroup.counter(counterName);
            Assert.assertEquals((String)"Reporters were not properly instantiated", (long)2L, (long)testRegistry.getReporters().size());
            CollectingMetricsReporter.MetricGroupAndName nameAndGroup = reporter1.getAddedMetrics().stream().filter(nag -> nag.name.equals(counterName)).findAny().get();
            String metricName = nameAndGroup.name;
            MetricGroup group = nameAndGroup.group;
            Assert.assertEquals((Object)"A-B-C-D-1", (Object)group.getMetricIdentifier(metricName));
            Assert.assertEquals((Object)"A-B-C-D-1", (Object)group.getMetricIdentifier(metricName, FILTER_C));
            Assert.assertEquals((Object)"A-B-C-D-1", (Object)group.getMetricIdentifier(metricName, (CharacterFilter)reporter1));
            Assert.assertEquals((Object)"A-B-C-D-4", (Object)group.getMetricIdentifier(metricName, input -> input.replace("B", "X").replace(counterName, "4")));
            nameAndGroup = reporter2.getAddedMetrics().stream().filter(nag -> nag.name.equals(counterName)).findAny().get();
            metricName = nameAndGroup.name;
            group = nameAndGroup.group;
            Assert.assertEquals((Object)"A!B!X!D!1", (Object)group.getMetricIdentifier(metricName, (CharacterFilter)reporter2));
            Assert.assertEquals((Object)"A!B!X!D!1", (Object)group.getMetricIdentifier(metricName));
            Assert.assertEquals((Object)"A!B!X!D!1", (Object)group.getMetricIdentifier(metricName, FILTER_C));
            Assert.assertEquals((Object)"A!B!X!D!3", (Object)group.getMetricIdentifier(metricName, input -> input.replace("A", "X").replace(counterName, "3")));
        }
        finally {
            testRegistry.shutdown().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogicalScopeCachingForMultipleReporters() throws Exception {
        String counterName = "1";
        CollectingMetricsReporter reporter1 = new CollectingMetricsReporter(FILTER_B);
        CollectingMetricsReporter reporter2 = new CollectingMetricsReporter(FILTER_C);
        MetricRegistryImpl testRegistry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricReporter)reporter1), ReporterSetup.forReporter((String)"test2", (MetricReporter)reporter2)));
        try {
            MetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)testRegistry, (String)"host", (ResourceID)new ResourceID("id")).addGroup("B").addGroup("C");
            tmGroup.counter(counterName);
            Assert.assertEquals((String)"Reporters were not properly instantiated", (long)2L, (long)testRegistry.getReporters().size());
            Assert.assertEquals((Object)"taskmanager-X-C", (Object)((FrontMetricGroup)reporter1.findAdded((String)counterName).group).getLogicalScope((CharacterFilter)reporter1, '-'));
            Assert.assertEquals((Object)"taskmanager,B,X", (Object)((FrontMetricGroup)reporter2.findAdded((String)counterName).group).getLogicalScope((CharacterFilter)reporter2, ','));
        }
        finally {
            testRegistry.shutdown().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScopeGenerationWithoutReporters() throws Exception {
        Configuration config = new Configuration();
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A.B.C.D");
        MetricRegistryImpl testRegistry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(config));
        try {
            TaskManagerMetricGroup group = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)testRegistry, (String)"host", (ResourceID)new ResourceID("id"));
            Assert.assertEquals((String)"MetricReporters list should be empty", (long)0L, (long)testRegistry.getReporters().size());
            Assert.assertEquals((Object)"A.B.X.D.1", (Object)group.getMetricIdentifier("1", FILTER_C));
            Assert.assertEquals((Object)"A.X.C.D.1", (Object)group.getMetricIdentifier("1", FILTER_B));
            Assert.assertEquals((Object)"A.X.C.D.1", (Object)group.getMetricIdentifier("1", FILTER_B, -1, '.'));
            Assert.assertEquals((Object)"A.X.C.D.1", (Object)group.getMetricIdentifier("1", FILTER_B, 2, '.'));
        }
        finally {
            testRegistry.shutdown().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllVariablesDoesNotDeadlock() throws InterruptedException {
        BlockerSync parentSync = new BlockerSync();
        BlockerSync childSync = new BlockerSync();
        AtomicReference<BlockerSync> syncRef = new AtomicReference<BlockerSync>();
        TestingMetricRegistry registry = TestingMetricRegistry.builder().setRegisterConsumer((metric, metricName, group) -> {
            ((BlockerSync)syncRef.get()).blockNonInterruptible();
            group.getAllVariables();
        }).build();
        GenericMetricGroup parent = new GenericMetricGroup((MetricRegistry)registry, (AbstractMetricGroup)UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup(), "parent");
        MetricGroup child = parent.addGroup("child");
        Thread parentRegisteringThread = new Thread(() -> AbstractMetricGroupTest.lambda$testGetAllVariablesDoesNotDeadlock$5((MetricGroup)parent));
        Thread childRegisteringThread = new Thread(() -> child.counter("child_counter"));
        try {
            syncRef.set(childSync);
            childRegisteringThread.start();
            childSync.awaitBlocker();
            syncRef.set(parentSync);
            parentRegisteringThread.start();
            parentSync.awaitBlocker();
            childSync.releaseBlocker();
            childRegisteringThread.join(10000L);
            parentSync.releaseBlocker();
            parentRegisteringThread.join();
        }
        finally {
            parentSync.releaseBlocker();
            childSync.releaseBlocker();
            parentRegisteringThread.join();
            childRegisteringThread.join();
        }
    }

    private static /* synthetic */ void lambda$testGetAllVariablesDoesNotDeadlock$5(MetricGroup parent) {
        parent.counter("parent_counter");
    }
}

