/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ResourceProfileTest
extends TestLogger {
    private static final MemorySize TOO_LARGE_MEMORY = ResourceProfile.MAX_MEMORY_SIZE_TO_LOG.add(MemorySize.ofMebiBytes((long)10L));
    private static final String EXTERNAL_RESOURCE_NAME = "gpu";

    @Test
    public void testAllFieldsNoLessThanProfile() {
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).build();
        ResourceProfile rp3 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).build();
        ResourceProfile rp4 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).build();
        Assert.assertFalse((boolean)rp1.allFieldsNoLessThan(rp2));
        Assert.assertTrue((boolean)rp2.allFieldsNoLessThan(rp1));
        Assert.assertFalse((boolean)rp1.allFieldsNoLessThan(rp3));
        Assert.assertTrue((boolean)rp3.allFieldsNoLessThan(rp1));
        Assert.assertFalse((boolean)rp2.allFieldsNoLessThan(rp3));
        Assert.assertFalse((boolean)rp3.allFieldsNoLessThan(rp2));
        Assert.assertTrue((boolean)rp4.allFieldsNoLessThan(rp1));
        Assert.assertTrue((boolean)rp4.allFieldsNoLessThan(rp2));
        Assert.assertTrue((boolean)rp4.allFieldsNoLessThan(rp3));
        Assert.assertTrue((boolean)rp4.allFieldsNoLessThan(rp4));
        ResourceProfile rp5 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        Assert.assertFalse((boolean)rp4.allFieldsNoLessThan(rp5));
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        Assert.assertFalse((boolean)rp1.allFieldsNoLessThan(ResourceProfile.fromResourceSpec((ResourceSpec)rs1)));
        Assert.assertTrue((boolean)ResourceProfile.fromResourceSpec((ResourceSpec)rs1).allFieldsNoLessThan(ResourceProfile.fromResourceSpec((ResourceSpec)rs2)));
        Assert.assertFalse((boolean)ResourceProfile.fromResourceSpec((ResourceSpec)rs2).allFieldsNoLessThan(ResourceProfile.fromResourceSpec((ResourceSpec)rs1)));
    }

    @Test
    public void testUnknownNoLessThanUnknown() {
        Assert.assertTrue((boolean)ResourceProfile.UNKNOWN.allFieldsNoLessThan(ResourceProfile.UNKNOWN));
    }

    @Test
    public void testMatchRequirement() {
        ResourceProfile resource1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).build();
        ResourceProfile resource2 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        ResourceProfile requirement1 = ResourceProfile.UNKNOWN;
        ResourceProfile requirement2 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).build();
        ResourceProfile requirement3 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assert.assertTrue((boolean)resource1.isMatching(requirement1));
        Assert.assertTrue((boolean)resource1.isMatching(requirement2));
        Assert.assertFalse((boolean)resource1.isMatching(requirement3));
        Assert.assertTrue((boolean)resource2.isMatching(requirement1));
        Assert.assertFalse((boolean)resource2.isMatching(requirement2));
        Assert.assertTrue((boolean)resource2.isMatching(requirement3));
    }

    @Test
    public void testEquals() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        Assert.assertEquals((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs1), (Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs2));
        ResourceSpec rs3 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        ResourceSpec rs4 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        Assert.assertNotEquals((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs3), (Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs4));
        ResourceSpec rs5 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        MemorySize networkMemory = MemorySize.ofMebiBytes((long)100L);
        Assert.assertEquals((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs3, (MemorySize)networkMemory), (Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs5, (MemorySize)networkMemory));
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(1.1).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp3 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(110).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp4 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(110).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp5 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(110).setNetworkMemoryMB(100).build();
        ResourceProfile rp6 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(110).setNetworkMemoryMB(100).build();
        ResourceProfile rp7 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(110).build();
        ResourceProfile rp8 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        Assert.assertNotEquals((Object)rp1, (Object)rp2);
        Assert.assertNotEquals((Object)rp1, (Object)rp3);
        Assert.assertNotEquals((Object)rp1, (Object)rp4);
        Assert.assertNotEquals((Object)rp1, (Object)rp5);
        Assert.assertNotEquals((Object)rp1, (Object)rp6);
        Assert.assertNotEquals((Object)rp1, (Object)rp7);
        Assert.assertEquals((Object)rp1, (Object)rp8);
    }

    @Test
    public void testGet() {
        ResourceSpec rs = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.6)).build();
        ResourceProfile rp = ResourceProfile.fromResourceSpec((ResourceSpec)rs, (MemorySize)MemorySize.ofMebiBytes((long)50L));
        Assert.assertEquals((Object)new CPUResource(1.0), (Object)rp.getCpuCores());
        Assert.assertEquals((long)150L, (long)rp.getTotalMemory().getMebiBytes());
        Assert.assertEquals((long)100L, (long)rp.getOperatorsMemory().getMebiBytes());
        Assert.assertEquals((Object)new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.6), rp.getExtendedResources().get(EXTERNAL_RESOURCE_NAME));
    }

    @Test
    public void testMerge() {
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).setNetworkMemoryMB(200).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.0)).build();
        ResourceProfile rp1MergeRp1 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).setNetworkMemoryMB(200).build();
        ResourceProfile rp1MergeRp2 = ResourceProfile.newBuilder().setCpuCores(3.0).setTaskHeapMemoryMB(300).setTaskOffHeapMemoryMB(300).setManagedMemoryMB(300).setNetworkMemoryMB(300).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.0)).build();
        ResourceProfile rp2MergeRp2 = ResourceProfile.newBuilder().setCpuCores(4.0).setTaskHeapMemoryMB(400).setTaskOffHeapMemoryMB(400).setManagedMemoryMB(400).setNetworkMemoryMB(400).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 4.0)).build();
        Assert.assertEquals((Object)rp1MergeRp1, (Object)rp1.merge(rp1));
        Assert.assertEquals((Object)rp1MergeRp2, (Object)rp1.merge(rp2));
        Assert.assertEquals((Object)rp1MergeRp2, (Object)rp2.merge(rp1));
        Assert.assertEquals((Object)rp2MergeRp2, (Object)rp2.merge(rp2));
        Assert.assertEquals((Object)ResourceProfile.UNKNOWN, (Object)rp1.merge(ResourceProfile.UNKNOWN));
        Assert.assertEquals((Object)ResourceProfile.UNKNOWN, (Object)ResourceProfile.UNKNOWN.merge(rp1));
        Assert.assertEquals((Object)ResourceProfile.UNKNOWN, (Object)ResourceProfile.UNKNOWN.merge(ResourceProfile.UNKNOWN));
        Assert.assertEquals((Object)ResourceProfile.ANY, (Object)rp1.merge(ResourceProfile.ANY));
        Assert.assertEquals((Object)ResourceProfile.ANY, (Object)ResourceProfile.ANY.merge(rp1));
        Assert.assertEquals((Object)ResourceProfile.ANY, (Object)ResourceProfile.ANY.merge(ResourceProfile.ANY));
    }

    @Test
    public void testMergeWithOverflow() {
        CPUResource largeDouble = new CPUResource(Double.MAX_VALUE);
        MemorySize largeMemory = MemorySize.MAX_VALUE.subtract(MemorySize.parse((String)"100m"));
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(3.0).setTaskHeapMemoryMB(300).setTaskOffHeapMemoryMB(300).setManagedMemoryMB(300).setNetworkMemoryMB(300).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(largeDouble).setTaskHeapMemory(largeMemory).setTaskOffHeapMemory(largeMemory).setManagedMemory(largeMemory).setNetworkMemory(largeMemory).build();
        ArrayList<ArithmeticException> exceptions = new ArrayList<ArithmeticException>();
        try {
            rp2.merge(rp2);
        }
        catch (ArithmeticException e) {
            exceptions.add(e);
        }
        try {
            rp2.merge(rp1);
        }
        catch (ArithmeticException e) {
            exceptions.add(e);
        }
        try {
            rp1.merge(rp2);
        }
        catch (ArithmeticException e) {
            exceptions.add(e);
        }
        Assert.assertEquals((long)3L, (long)exceptions.size());
    }

    @Test
    public void testSubtract() {
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).setNetworkMemoryMB(200).build();
        ResourceProfile rp3 = ResourceProfile.newBuilder().setCpuCores(3.0).setTaskHeapMemoryMB(300).setTaskOffHeapMemoryMB(300).setManagedMemoryMB(300).setNetworkMemoryMB(300).build();
        Assert.assertEquals((Object)rp1, (Object)rp3.subtract(rp2));
        Assert.assertEquals((Object)rp1, (Object)rp2.subtract(rp1));
        try {
            rp1.subtract(rp2);
            Assert.fail((String)"The subtract should failed due to trying to subtract a larger resource");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)ResourceProfile.ANY, (Object)ResourceProfile.ANY.subtract(rp3));
        Assert.assertEquals((Object)ResourceProfile.ANY, (Object)ResourceProfile.ANY.subtract(ResourceProfile.ANY));
        Assert.assertEquals((Object)ResourceProfile.ANY, (Object)rp3.subtract(ResourceProfile.ANY));
        Assert.assertEquals((Object)ResourceProfile.UNKNOWN, (Object)ResourceProfile.UNKNOWN.subtract(rp3));
        Assert.assertEquals((Object)ResourceProfile.UNKNOWN, (Object)rp3.subtract(ResourceProfile.UNKNOWN));
        Assert.assertEquals((Object)ResourceProfile.UNKNOWN, (Object)ResourceProfile.UNKNOWN.subtract(ResourceProfile.UNKNOWN));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubtractWithInfValues() {
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(Double.MAX_VALUE).setTaskHeapMemoryMB(Integer.MAX_VALUE).setTaskOffHeapMemoryMB(Integer.MAX_VALUE).setManagedMemoryMB(Integer.MAX_VALUE).setNetworkMemoryMB(Integer.MAX_VALUE).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 4.0)).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).setNetworkMemoryMB(200).build();
        rp2.subtract(rp1);
    }

    @Test
    public void testMultiply() {
        ResourceProfile rp1;
        int by = 3;
        ResourceProfile rp2 = rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        for (int i = 1; i < 3; ++i) {
            rp2 = rp2.merge(rp1);
        }
        Assert.assertEquals((Object)rp2, (Object)rp1.multiply(3));
    }

    @Test
    public void testMultiplyZero() {
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assert.assertEquals((Object)ResourceProfile.ZERO, (Object)rp1.multiply(0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMultiplyNegative() {
        ResourceProfile rp = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        rp.multiply(-2);
    }

    @Test
    public void testFromSpecWithSerializationCopy() throws Exception {
        ResourceSpec copiedSpec = (ResourceSpec)CommonTestUtils.createCopySerializable((Serializable)ResourceSpec.UNKNOWN);
        ResourceProfile profile = ResourceProfile.fromResourceSpec((ResourceSpec)copiedSpec);
        Assert.assertEquals((Object)ResourceProfile.fromResourceSpec((ResourceSpec)ResourceSpec.UNKNOWN), (Object)profile);
    }

    @Test
    public void testSingletonPropertyOfUnknown() throws Exception {
        ResourceProfile copiedProfile = (ResourceProfile)CommonTestUtils.createCopySerializable((Serializable)ResourceProfile.UNKNOWN);
        Assert.assertSame((Object)ResourceProfile.UNKNOWN, (Object)copiedProfile);
    }

    @Test
    public void testSingletonPropertyOfAny() throws Exception {
        ResourceProfile copiedProfile = (ResourceProfile)CommonTestUtils.createCopySerializable((Serializable)ResourceProfile.ANY);
        Assert.assertSame((Object)ResourceProfile.ANY, (Object)copiedProfile);
    }

    @Test
    public void doesNotIncludeCPUAndMemoryInToStringIfTheyAreTooLarge() {
        double tooLargeCpuCount = ResourceProfile.MAX_CPU_CORE_NUMBER_TO_LOG.doubleValue() + 1.0;
        ResourceProfile resourceProfile = ResourceProfileTest.createResourceProfile(tooLargeCpuCount, TOO_LARGE_MEMORY);
        Assert.assertThat((Object)resourceProfile.toString(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.not(this.containsCPUCores()), (Matcher)CoreMatchers.not(this.containsTaskHeapMemory())));
    }

    @Test
    public void includesCPUAndMemoryInToStringIfTheyAreBelowThreshold() {
        ResourceProfile resourceProfile = ResourceProfileTest.createResourceProfile(1.0, MemorySize.ofMebiBytes((long)4L));
        Assert.assertThat((Object)resourceProfile.toString(), (Matcher)CoreMatchers.allOf(this.containsCPUCores(), this.containsTaskHeapMemory()));
    }

    @Test
    public void testZeroExtendedResourceFromConstructor() {
        ResourceProfile resourceProfile = ResourceProfile.newBuilder().setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 0.0)).build();
        Assert.assertEquals((long)resourceProfile.getExtendedResources().size(), (long)0L);
    }

    @Test
    public void testZeroExtendedResourceFromSubtract() {
        ResourceProfile resourceProfile = ResourceProfile.newBuilder().setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assert.assertEquals((long)resourceProfile.subtract(resourceProfile).getExtendedResources().size(), (long)0L);
    }

    private Matcher<String> containsTaskHeapMemory() {
        return CoreMatchers.containsString((String)"taskHeapMemory=");
    }

    private Matcher<String> containsCPUCores() {
        return CoreMatchers.containsString((String)"cpuCores=");
    }

    private static ResourceProfile createResourceProfile(double cpu, MemorySize taskHeapMemory) {
        return ResourceProfile.newBuilder().setCpuCores(cpu).setTaskHeapMemory(taskHeapMemory).build();
    }
}

